/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.provider.dim.EMemberType;
import com.ibm.cognos.aurora.api.query.provider.dim.ERollupType;
import com.ibm.cognos.aurora.api.query.provider.dim.ETreeOp;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.qls.model.physical.olap.AbstractOlapMetadata;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.dom4j.Element;

public class OlapMember
extends AbstractOlapMetadata
implements IOlapMember {
    private String mDescription;
    private EMemberType mMemberType = EMemberType.UNKNOWN;
    private ERollupType mRollupType = ERollupType.UNKNOWN;
    private long mChildrenCardinality;
    private int mParentCount;
    private IOlapLevel mParentLevel;
    private String mParentUniqueName;
    private long mOrdinal;

    public OlapMember(IOlapModel model, IOlapLevel parent) {
        super(model, (IOlapMetadata)parent);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.OLAP_MEMBER;
    }

    public IOlapCube getCube() {
        return this.getDimension().getCube();
    }

    public IOlapDimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    public IOlapHierarchy getHierarchy() {
        return this.getLevel().getHierarchy();
    }

    public IOlapLevel getLevel() {
        return (IOlapLevel)this.getParent();
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public EMemberType getMemberType() {
        return this.mMemberType;
    }

    public void setMemberType(EMemberType memberType) {
        this.mMemberType = memberType;
    }

    public ERollupType getRollupType() {
        return this.mRollupType;
    }

    public void setRollupType(ERollupType rollupType) {
        this.mRollupType = rollupType;
    }

    public long getChildrenCardinality() {
        return this.mChildrenCardinality;
    }

    public void setChildrenCardinality(long childrenCardinality) {
        this.mChildrenCardinality = childrenCardinality;
    }

    public int getParentCount() {
        return this.mParentCount;
    }

    public void setParentCount(int parentCount) {
        this.mParentCount = parentCount;
    }

    public IOlapLevel getParentLevel() {
        return this.mParentLevel;
    }

    public void setParentLevel(IOlapLevel parentLevel) {
        this.mParentLevel = parentLevel;
    }

    public String getParentUniqueName() {
        return this.mParentUniqueName;
    }

    public void setParentUniqueName(String parentUniqueName) {
        this.mParentUniqueName = parentUniqueName;
    }

    public List<IOlapMember> fetchRelatedMembers(EnumSet<ETreeOp> treeOps) {
        return this.getCube().fetchMembers(this.getUniqueName(), treeOps);
    }

    public void populateFromRecord(IMemberRecord record) {
        this.setInternalName(record.getName());
        this.setName(record.getName());
        this.setUniqueName(record.getUniqueName());
        this.setCaption(record.getCaption());
        this.setChildrenCardinality(record.getChildrenCardinality());
        this.setDescription(record.getDescription());
        this.setMemberType(record.getMemberType());
        this.setRollupType(record.getRollupType());
        this.setParentCount(record.getParentCount());
        this.setParentUniqueName(record.getParentUniqueName());
        this.setOrdinal(record.getOrdinal());
        int parentLevelNum = record.getParentLevel();
        if (parentLevelNum != -1) {
            this.setParentLevel((IOlapLevel)this.getHierarchy().getLevels().get(parentLevelNum));
        }
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        super.encodePropertiesElement(elem, ctx);
        if (null != this.mDescription) {
            elem.addElement("description").setText(this.mDescription);
        }
        if (null != this.mMemberType) {
            elem.addElement("memberType").setText(this.mMemberType.name());
        } else {
            elem.addElement("memberType").setText(EMemberType.UNKNOWN.name());
        }
        if (null != this.mRollupType) {
            elem.addElement("rollupType").setText(this.mRollupType.name());
        } else {
            elem.addElement("rollupType").setText(ERollupType.UNKNOWN.name());
        }
        elem.addElement("childrenCardinality").setText(Long.toString(this.mChildrenCardinality));
        elem.addElement("parentCount").setText(Integer.toString(this.mParentCount));
        if (null != this.mParentLevel) {
            elem.addElement("parentLevelRef").setText(this.mParentLevel.getInternalUniqueName());
        }
        if (null != this.mParentUniqueName) {
            elem.addElement("parentUniqueName").setText(this.mParentUniqueName);
        }
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        super.decodePropertiesElement(elem, ctx);
        Element propElem = elem.element("description");
        this.mDescription = null != propElem ? propElem.getText() : null;
        this.mMemberType = EMemberType.valueOf((String)elem.elementText("memberType"));
        this.mRollupType = ERollupType.valueOf((String)elem.elementText("rollupType"));
        this.mChildrenCardinality = Long.parseLong(elem.elementText("childrenCardinality"));
        this.mParentCount = Integer.parseInt(elem.elementText("parentCount"));
        propElem = elem.element("parentLevelRef");
        this.mParentLevel = null != propElem ? (IOlapLevel)this.getOlapModel().lookupMetadata(propElem.getText(), IOlapLevel.class) : null;
        propElem = elem.element("parentUniqueName");
        this.mParentUniqueName = null != propElem ? propElem.getText() : null;
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodePropertiesBinary(out, ctx);
        if (null != this.mDescription) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mDescription);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mMemberType) {
            out.writeShort(this.mMemberType.ordinal());
        } else {
            out.writeShort(EMemberType.UNKNOWN.ordinal());
        }
        if (null != this.mRollupType) {
            out.writeShort(this.mRollupType.ordinal());
        } else {
            out.writeShort(ERollupType.UNKNOWN.ordinal());
        }
        out.writeLong(this.mOrdinal);
        out.writeLong(this.mChildrenCardinality);
        out.writeInt(this.mParentCount);
        if (null != this.mParentLevel) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mParentLevel.getInternalUniqueName());
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mParentUniqueName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mParentUniqueName);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodePropertiesBinary(in, ctx);
        this.mDescription = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mMemberType = EMemberType.values()[in.readShort()];
        this.mRollupType = ERollupType.values()[in.readShort()];
        this.mOrdinal = in.readLong();
        this.mChildrenCardinality = in.readLong();
        this.mParentCount = in.readInt();
        this.mParentLevel = in.readBoolean() ? (IOlapLevel)this.getOlapModel().lookupMetadata(EncodeUtil.readString((DataInput)in), IOlapLevel.class) : null;
        this.mParentUniqueName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
    }

    public long getOrdinal() {
        return this.mOrdinal;
    }

    public void setOrdinal(long ordinal) {
        this.mOrdinal = ordinal;
    }
}

