/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMemberProperty;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.provider.dim.EPropertyRole;
import com.ibm.cognos.aurora.api.query.provider.dim.IPropertyRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.qls.model.physical.olap.AbstractOlapMetadata;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public final class OlapMemberProperty
extends AbstractOlapMetadata
implements IOlapMemberProperty {
    private IDataType mDataType = DataTypes.getUnknownType();
    private EPropertyRole mRole = EPropertyRole.CUSTOM_PROPERTY;

    public OlapMemberProperty(IOlapModel model, IOlapLevel parent) {
        super(model, (IOlapMetadata)parent);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.OLAP_MEMBER_PROPERTY;
    }

    public EPropertyRole getRole() {
        return this.mRole;
    }

    public void setRole(EPropertyRole role) {
        this.mRole = role;
    }

    public IOlapCube getCube() {
        return this.getDimension().getCube();
    }

    public IOlapDimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    public IOlapHierarchy getHierarchy() {
        return this.getLevel().getHierarchy();
    }

    public IOlapLevel getLevel() {
        return (IOlapLevel)this.getParent();
    }

    public IDataType getDataType() {
        return this.mDataType;
    }

    public void setDataType(IDataType dataType) {
        this.mDataType = dataType;
    }

    public void populateFromRecord(IPropertyRecord record) {
        this.setInternalName(record.getName());
        this.setName(record.getName());
        this.setUniqueName(record.getUniqueName());
        this.setCaption(record.getCaption());
        this.setDataType(record.getDataType());
        this.setRole(record.getRoleType());
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        super.encodePropertiesElement(elem, ctx);
        if (null != this.mDataType) {
            DataTypes.encodeElement((Element)elem.addElement("dataType"), (EncoderContext)ctx, (IDataType)this.mDataType);
        } else {
            DataTypes.encodeElement((Element)elem.addElement("dataType"), (EncoderContext)ctx, (IDataType)DataTypes.getUnknownType());
        }
        if (null != this.mRole) {
            elem.addElement("role").setText(this.mRole.name());
        } else {
            elem.addElement("role").setText(EPropertyRole.CUSTOM_PROPERTY.name());
        }
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        super.decodePropertiesElement(elem, ctx);
        this.mDataType = DataTypes.decodeElement((Element)elem.element("dataType"), (EncoderContext)ctx);
        this.mRole = EPropertyRole.valueOf((String)elem.elementText("role"));
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodePropertiesBinary(out, ctx);
        if (null != this.mDataType) {
            DataTypes.encodeBinary((DataOutput)out, (EncoderContext)ctx, (IDataType)this.mDataType);
        } else {
            DataTypes.encodeBinary((DataOutput)out, (EncoderContext)ctx, (IDataType)DataTypes.getUnknownType());
        }
        if (null != this.mRole) {
            out.writeShort(this.mRole.ordinal());
        } else {
            out.writeShort(EPropertyRole.CUSTOM_PROPERTY.ordinal());
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodePropertiesBinary(in, ctx);
        this.mDataType = DataTypes.decodeBinary((DataInput)in, (EncoderContext)ctx);
        this.mRole = EPropertyRole.values()[in.readShort()];
    }
}

