/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalModelType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.event.IPhysicalModelWatcher;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapCube;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapDimension;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapHierarchy;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapLevel;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMeasure;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMeasureHierarchy;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMeasureLevel;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMemberProperty;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapModelWatcher;
import java.util.ArrayList;
import java.util.List;

public class OlapModel
extends AbstractPhysicalModel
implements IOlapModel {
    public EPhysicalModelType getType() {
        return EPhysicalModelType.OLAP;
    }

    @Override
    public IPhysicalMetadata createMetadata(EPhysicalMetadataType type, IPhysicalMetadata parent) {
        switch (type) {
            case OLAP_CUBE: {
                return new OlapCube(this);
            }
            case OLAP_DIMENSION: {
                IOlapCube cube = (IOlapCube)parent;
                return new OlapDimension((IOlapModel)this, cube);
            }
            case OLAP_HIERARCHY: {
                IOlapDimension dim = (IOlapDimension)parent;
                if (dim.isMeasureDimension()) {
                    return new OlapMeasureHierarchy((IOlapModel)this, dim);
                }
                return new OlapHierarchy((IOlapModel)this, dim);
            }
            case OLAP_LEVEL: {
                IOlapHierarchy hier = (IOlapHierarchy)parent;
                if (hier.getDimension().isMeasureDimension()) {
                    return new OlapMeasureLevel((IOlapModel)this, hier);
                }
                return new OlapLevel((IOlapModel)this, hier);
            }
            case OLAP_MEMBER_PROPERTY: {
                IOlapLevel level = (IOlapLevel)parent;
                return new OlapMemberProperty((IOlapModel)this, level);
            }
            case OLAP_MEASURE: {
                IOlapLevel level = (IOlapLevel)parent;
                return new OlapMeasure((IOlapModel)this, level);
            }
        }
        throw new IllegalArgumentException("Unsupported metadata type: " + String.valueOf(type));
    }

    public List<IOlapCube> getCubes() {
        return this.getRoots(EPhysicalMetadataType.OLAP_CUBE, IOlapCube.class);
    }

    public List<IOlapCube> findCubes(String catalogName, String cubeName) {
        ArrayList<IOlapCube> results = new ArrayList<IOlapCube>();
        for (IOlapCube cube : this.getCubes()) {
            if (null != catalogName && !catalogName.equals(cube.getCatalogName()) || null != cubeName && !cubeName.equals(cube.getName())) continue;
            results.add(cube);
        }
        return results;
    }

    public IOlapCube findCube(String catalogName, String cubeName) {
        for (IOlapCube cube : this.getCubes()) {
            if (null != catalogName && !catalogName.equals(cube.getCatalogName()) || null != cubeName && !cubeName.equals(cube.getName())) continue;
            return cube;
        }
        return null;
    }

    public void addCube(IOlapCube cube) {
        this.addRoot((IPhysicalMetadata)cube);
    }

    public IPhysicalModelWatcher createWatcher(IQueryLogicalStorage qls, boolean isAsynchronous, long updateInterval) {
        return new OlapModelWatcher(qls, this, isAsynchronous, updateInterval);
    }
}

