/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMeasure;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.dim.EPropertyRole;
import com.ibm.cognos.aurora.api.query.provider.dim.ICubeRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.IHierarchyRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.ILevelRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IPropertyRecord;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModelBuilder;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapCube;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapDimension;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapHierarchy;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapLevel;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMeasureHierarchy;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMeasureLevel;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMemberProperty;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapModel;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.Restrictions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OlapModelBuilder
extends AbstractPhysicalModelBuilder {
    private static final String MEMBER_CAPTION = "MEMBER_CAPTION";
    private final List<CubeInfo> mCubesToImport = new ArrayList<CubeInfo>();

    public void addCube(String catalogName, String cubeName) {
        this.mCubesToImport.add(new CubeInfo(catalogName, cubeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPhysicalModel build() {
        if (null == this.getQLS()) {
            throw new IllegalStateException("qls was not set");
        }
        if (null == this.getDataSource()) {
            throw new IllegalStateException("dataSource was not set");
        }
        OlapModel model = new OlapModel();
        model.setCreationTime(new Date());
        model.setDataSource(this.getDataSource());
        model.setQLS(this.getQLS());
        model.setLocale(this.getLocale());
        IConnectionSpec connSpec = this.getDataSource().getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        IProviderManager providerMan = this.getQLS().getProviderManager();
        IDimensionalDataProvider provider = (IDimensionalDataProvider)providerMan.getDataProvider(providerType);
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        if (this.getLocale() != null) {
            queryContext.setContentLocale(this.getLocale().toLocale());
        }
        try {
            for (CubeInfo ci : this.mCubesToImport) {
                Restrictions rest = new Restrictions();
                rest.put("CATALOG_NAME", ci.getCatalogName());
                rest.put("CUBE_NAME", ci.getCubeName());
                List records = provider.discoverCubes(this.getDataSource(), (IRestrictions)rest, (IQueryContext)queryContext);
                if (records.isEmpty()) {
                    throw new QLSRuntimeException(QLSMessageKeys.MOD_CubeNotFound, ci.getCatalogName(), (Object)ci.getCubeName());
                }
                this.populateCube(provider, queryContext, model, (ICubeRecord)records.get(0));
            }
        }
        finally {
            queryContext.terminate();
        }
        return model;
    }

    private void populateCube(IDimensionalDataProvider provider, IQueryContext queryContext, OlapModel model, ICubeRecord cubeRec) {
        OlapCube cube = new OlapCube(model);
        cube.populateFromRecord(cubeRec);
        this.substituteInternalName(cube);
        model.addCube(cube);
        Restrictions rest = new Restrictions();
        rest.put("CATALOG_NAME", cube.getCatalogName());
        rest.put("CUBE_NAME", cube.getName());
        List dimRecords = provider.discoverDimensions(this.getDataSource(), (IRestrictions)rest, queryContext);
        for (IDimensionRecord dimRec : dimRecords) {
            this.populateDimension(provider, queryContext, cube, dimRec);
        }
    }

    private void populateDimension(IDimensionalDataProvider provider, IQueryContext queryContext, OlapCube cube, IDimensionRecord dimRec) {
        OlapDimension dim = new OlapDimension(cube.getOlapModel(), cube);
        dim.populateFromRecord(dimRec);
        this.substituteInternalName(dim);
        cube.addDimension(dim);
        Restrictions rest = new Restrictions();
        rest.put("CATALOG_NAME", cube.getCatalogName());
        rest.put("CUBE_NAME", cube.getName());
        rest.put("DIMENSION_UNIQUE_NAME", dim.getUniqueName());
        List hierRecords = provider.discoverHierarchies(this.getDataSource(), (IRestrictions)rest, queryContext);
        for (IHierarchyRecord hierRec : hierRecords) {
            this.populateHierarchy(provider, queryContext, dim, hierRec);
        }
    }

    private void populateHierarchy(IDimensionalDataProvider provider, IQueryContext queryContext, OlapDimension dim, IHierarchyRecord hierRec) {
        OlapHierarchy hier = dim.isMeasureDimension() ? new OlapMeasureHierarchy(dim.getOlapModel(), dim) : new OlapHierarchy(dim.getOlapModel(), dim);
        hier.populateFromRecord(hierRec);
        this.substituteInternalName(hier);
        dim.addHierarchy(hier);
        Restrictions rest = new Restrictions();
        rest.put("CATALOG_NAME", dim.getCube().getCatalogName());
        rest.put("CUBE_NAME", dim.getCube().getName());
        rest.put("HIERARCHY_UNIQUE_NAME", hier.getUniqueName());
        List levelRecords = provider.discoverLevels(this.getDataSource(), (IRestrictions)rest, queryContext);
        for (ILevelRecord levelRec : levelRecords) {
            this.populateLevel(provider, queryContext, hier, levelRec);
        }
    }

    private void populateLevel(IDimensionalDataProvider provider, IQueryContext queryContext, OlapHierarchy hier, ILevelRecord levelRec) {
        IOlapModel model = hier.getOlapModel();
        OlapLevel level = hier.getDimension().isMeasureDimension() ? new OlapMeasureLevel(model, hier) : new OlapLevel(model, hier);
        level.populateFromRecord(levelRec);
        this.substituteInternalName(level);
        hier.addLevel(level);
        Restrictions rest = new Restrictions();
        rest.put("CATALOG_NAME", hier.getCube().getCatalogName());
        rest.put("CUBE_NAME", hier.getCube().getName());
        if (hier.isParentChild()) {
            rest.put("HIERARCHY_UNIQUE_NAME", hier.getUniqueName());
            rest.put("LEVEL_NUMBER", level.getLevelNumber());
        } else {
            rest.put("LEVEL_UNIQUE_NAME", level.getUniqueName());
        }
        OlapMemberProperty captionProp = new OlapMemberProperty(model, level);
        captionProp.setInternalName(MEMBER_CAPTION);
        captionProp.setName(MEMBER_CAPTION);
        captionProp.setCaption(MEMBER_CAPTION);
        captionProp.setUniqueName(MEMBER_CAPTION);
        captionProp.setDataType((IDataType)DataTypes.getStringType((int)Integer.MAX_VALUE));
        captionProp.setRole(EPropertyRole.MEMBER_CAPTION);
        level.addMemberProperty(captionProp);
        List propRecords = provider.discoverProperties(this.getDataSource(), (IRestrictions)rest, queryContext);
        for (IPropertyRecord propRec : propRecords) {
            OlapMemberProperty prop = new OlapMemberProperty(model, level);
            prop.populateFromRecord(propRec);
            level.addMemberProperty(prop);
        }
        if (hier.getDimension().isMeasureDimension()) {
            OlapCube cube = (OlapCube)hier.getCube();
            OlapMeasureLevel measureLevel = (OlapMeasureLevel)level;
            List memRecords = provider.discoverMembers(this.getDataSource(), (IRestrictions)rest, queryContext);
            for (IMemberRecord memRec : memRecords) {
                IOlapMeasure measure = (IOlapMeasure)cube.getMemberFromRecord(memRec);
                measureLevel.addMeasure(measure);
            }
        }
    }

    private static final class CubeInfo {
        private final String mCatalogName;
        private final String mCubeName;

        public CubeInfo(String catalogName, String cubeName) {
            this.mCatalogName = catalogName;
            this.mCubeName = cubeName;
        }

        public String getCatalogName() {
            return this.mCatalogName;
        }

        public String getCubeName() {
            return this.mCubeName;
        }
    }
}

