/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.rel;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.rel.ENullable;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.tabular.IColumnRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularDataProvider;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.rel.AbstractRelMetadata;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelModel;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public final class RelColumn
extends AbstractRelMetadata
implements IRelColumn {
    private String mColumnName;
    private IDataType mDataType = DataTypes.getUnknownType();
    private int mDecimalDigits = 0;
    private ENullable mNullable = ENullable.UNKNOWN;
    private String mRemarks;
    private int mSQLType = 12;
    private String mTypeName;

    public RelColumn(RelModel model, RelTable table) {
        super(model, table);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.REL_COLUMN;
    }

    public IRelTable getTable() {
        return (IRelTable)this.getParent();
    }

    public String getColumnName() {
        return this.mColumnName;
    }

    public void setColumnName(String columnName) {
        this.mColumnName = columnName;
    }

    public IDataType getDataType() {
        return this.mDataType;
    }

    public void setDataType(IDataType dataType) {
        this.mDataType = dataType;
    }

    public int getSQLType() {
        return this.mSQLType;
    }

    public void setSQLType(int sqlType) {
        this.mSQLType = sqlType;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public void setTypeName(String typeName) {
        this.mTypeName = typeName;
    }

    public int getDecimalDigits() {
        return this.mDecimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.mDecimalDigits = decimalDigits;
    }

    public ENullable getNullable() {
        return this.mNullable;
    }

    public void setNullable(ENullable nullable) {
        this.mNullable = nullable;
    }

    public String getRemarks() {
        return this.mRemarks;
    }

    public void setRemarks(String remarks) {
        this.mRemarks = remarks;
    }

    public IValueIterator fetchValues(boolean distinct, long limit) {
        IQueryLogicalStorage qls = ((AbstractPhysicalModel)this.getModel()).getQLS();
        IProviderManager providerMan = qls.getProviderManager();
        IDataSource dataSource = this.getModel().getDataSource();
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        ITabularDataProvider provider = (ITabularDataProvider)providerMan.getDataProvider(providerType);
        return provider.queryColumnValues(dataSource, this.getTable().getSchemaName(), this.getTable().getTableName(), this.getColumnName(), distinct, limit);
    }

    public void populateFromRecord(IColumnRecord record) {
        this.setInternalName(record.getColumnName());
        this.setColumnName(record.getColumnName());
        this.setDataType(record.getDataType());
        this.setDecimalDigits(record.getDecimalDigits());
        switch (record.getNullable()) {
            case 0: {
                this.setNullable(ENullable.NO_NULLS);
                break;
            }
            case 1: {
                this.setNullable(ENullable.NULLABLE);
                break;
            }
            default: {
                this.setNullable(ENullable.UNKNOWN);
            }
        }
        this.setRemarks(record.getRemarks());
        this.setSQLType(record.getSQLDataType());
        this.setTypeName(record.getTypeName());
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        if (null != this.mColumnName) {
            elem.addElement("columnName").setText(this.mColumnName);
        }
        if (null != this.mDataType) {
            DataTypes.encodeElement((Element)elem.addElement("dataType"), (EncoderContext)ctx, (IDataType)this.mDataType);
        }
        if (null != this.mNullable) {
            elem.addElement("nullable").setText(this.mNullable.name());
        }
        if (null != this.mTypeName) {
            elem.addElement("typeName").setText(this.mTypeName);
        }
        if (null != this.mRemarks) {
            elem.addElement("remarks").setText(this.mRemarks);
        }
        elem.addElement("sqlType").setText(Integer.toString(this.mSQLType));
        elem.addElement("decimalDigits").setText(Integer.toString(this.mDecimalDigits));
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        Element propElem = elem.element("columnName");
        if (null != propElem) {
            this.mColumnName = propElem.getText();
        }
        this.mDataType = null != (propElem = elem.element("dataType")) ? DataTypes.decodeElement((Element)propElem, (EncoderContext)ctx) : DataTypes.getUnknownType();
        propElem = elem.element("decimalDigits");
        this.mDecimalDigits = null != propElem ? Integer.parseInt(propElem.getText()) : 0;
        propElem = elem.element("nullable");
        this.mNullable = null != propElem ? ENullable.valueOf((String)propElem.getText()) : ENullable.UNKNOWN;
        propElem = elem.element("remarks");
        this.mRemarks = null != propElem ? propElem.getText() : null;
        propElem = elem.element("sqlType");
        this.mSQLType = null != propElem ? Integer.parseInt(propElem.getText()) : 0;
        propElem = elem.element("typeName");
        this.mTypeName = null != propElem ? propElem.getText() : null;
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        if (null != this.mColumnName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mColumnName);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mDataType) {
            out.writeBoolean(true);
            DataTypes.encodeBinary((DataOutput)out, (EncoderContext)ctx, (IDataType)this.mDataType);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.mDecimalDigits);
        if (null != this.mNullable) {
            out.writeByte(this.mNullable.ordinal());
        } else {
            out.writeByte(ENullable.UNKNOWN.ordinal());
        }
        if (null != this.mRemarks) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mRemarks);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.mSQLType);
        if (null != this.mTypeName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mTypeName);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mColumnName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mDataType = in.readBoolean() ? DataTypes.decodeBinary((DataInput)in, (EncoderContext)ctx) : null;
        this.mDecimalDigits = in.readInt();
        this.mNullable = ENullable.values()[in.readByte()];
        this.mRemarks = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mSQLType = in.readInt();
        this.mTypeName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
    }
}

