/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.rel;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalModelType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.event.IPhysicalModelWatcher;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelCrossReference;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelModel;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelPrimaryKey;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.NoChangeModelWatcher;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelColumn;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelCrossReference;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelPrimaryKey;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelTable;
import java.util.ArrayList;
import java.util.List;

public final class RelModel
extends AbstractPhysicalModel
implements IRelModel {
    public EPhysicalModelType getType() {
        return EPhysicalModelType.RELATIONAL;
    }

    @Override
    public IPhysicalMetadata createMetadata(EPhysicalMetadataType type, IPhysicalMetadata parent) {
        switch (type) {
            case REL_COLUMN: {
                return new RelColumn(this, (RelTable)parent);
            }
            case REL_CROSS_REFERENCE: {
                return new RelCrossReference(this);
            }
            case REL_PRIMARY_KEY: {
                return new RelPrimaryKey(this, (RelTable)parent);
            }
            case REL_TABLE: {
                return new RelTable(this);
            }
        }
        throw new IllegalArgumentException("Unsupported metadata type: " + String.valueOf(type));
    }

    public List<IRelTable> getTables() {
        return this.getRoots(EPhysicalMetadataType.REL_TABLE, IRelTable.class);
    }

    public List<IRelTable> findTables(String schemaName, String catalogName, String tableName) {
        ArrayList<IRelTable> results = new ArrayList<IRelTable>();
        for (IRelTable table : this.getTables()) {
            if (null != schemaName && !schemaName.equals(table.getSchemaName()) || null != catalogName && !catalogName.equals(table.getCatalogName()) || null != tableName && !tableName.equals(table.getTableName())) continue;
            results.add(table);
        }
        return results;
    }

    public IRelTable findTable(String schemaName, String catalogName, String tableName) {
        for (IRelTable table : this.getTables()) {
            if (null != schemaName && !schemaName.equals(table.getSchemaName()) || null != catalogName && !catalogName.equals(table.getCatalogName()) || null != tableName && !tableName.equals(table.getTableName())) continue;
            return table;
        }
        return null;
    }

    public void addTable(IRelTable table) {
        this.addRoot((IPhysicalMetadata)table);
    }

    public List<IRelPrimaryKey> getPrimaryKeys() {
        ArrayList<IRelPrimaryKey> primaryKeys = new ArrayList<IRelPrimaryKey>();
        for (IRelTable table : this.getTables()) {
            primaryKeys.addAll(table.getPrimaryKeys());
        }
        return primaryKeys;
    }

    public List<IRelCrossReference> getCrossReferences() {
        return this.getRoots(EPhysicalMetadataType.REL_CROSS_REFERENCE, IRelCrossReference.class);
    }

    public void addCrossReference(IRelCrossReference xref) {
        this.addRoot((IPhysicalMetadata)xref);
    }

    public IPhysicalModelWatcher createWatcher(IQueryLogicalStorage qls, boolean isAsynchronous, long updateInterval) {
        return new NoChangeModelWatcher(this);
    }
}

