/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.rel;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.tabular.IColumnRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ICrossReferenceRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.IPrimaryKeyRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITableRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularDataProvider;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModelBuilder;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelColumn;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelCrossReference;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelModel;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelPrimaryKey;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelTable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RelModelBuilder
extends AbstractPhysicalModelBuilder {
    private final List<TableInfo> mTablesToImport = new ArrayList<TableInfo>();

    public void addTable(String catalogName, String schemaName, String tableName) {
        this.mTablesToImport.add(new TableInfo(catalogName, schemaName, tableName));
    }

    @Override
    public IPhysicalModel build() {
        if (null == this.getQLS()) {
            throw new IllegalStateException("qls was not set");
        }
        if (null == this.getDataSource()) {
            throw new IllegalStateException("dataSource was not set");
        }
        if (null == this.getLocale()) {
            throw new IllegalStateException("locale was not set");
        }
        RelModel model = new RelModel();
        model.setCreationTime(new Date());
        model.setDataSource(this.getDataSource());
        model.setQLS(this.getQLS());
        IConnectionSpec connSpec = this.getDataSource().getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        IProviderManager providerMan = this.getQLS().getProviderManager();
        ITabularDataProvider provider = (ITabularDataProvider)providerMan.getDataProvider(providerType);
        for (TableInfo ti : this.mTablesToImport) {
            List records = provider.discoverTables(this.getDataSource(), ti.getCatalogName(), ti.getSchemaName(), ti.getTableName(), null);
            if (records.isEmpty()) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_TableNotFound, ti.getCatalogName(), (Object)ti.getSchemaName(), (Object)ti.getTableName());
            }
            this.populateTable(provider, model, (ITableRecord)records.get(0));
        }
        for (IRelTable primaryTable : model.getTables()) {
            for (IRelTable foreignTable : model.getTables()) {
                if (primaryTable == foreignTable) continue;
                List records = provider.discoverCrossReferences(this.getDataSource(), primaryTable.getCatalogName(), primaryTable.getSchemaName(), primaryTable.getTableName(), foreignTable.getCatalogName(), foreignTable.getSchemaName(), foreignTable.getTableName());
                for (ICrossReferenceRecord xrefRec : records) {
                    RelCrossReference xref = new RelCrossReference(model);
                    xref.populateFromRecord(xrefRec);
                    model.addCrossReference(xref);
                }
            }
        }
        return model;
    }

    private void populateTable(ITabularDataProvider provider, RelModel model, ITableRecord tableRec) {
        RelTable table = new RelTable(model);
        table.populateFromRecord(tableRec);
        this.substituteInternalName(table);
        List colRecords = provider.discoverColumns(this.getDataSource(), tableRec.getCatalogName(), tableRec.getSchemaName(), tableRec.getTableName(), null);
        for (IColumnRecord colRec : colRecords) {
            RelColumn column = new RelColumn(model, table);
            column.populateFromRecord(colRec);
            this.substituteInternalName(column);
            table.addColumn(column);
        }
        List pkRecords = provider.discoverPrimaryKeys(this.getDataSource(), tableRec.getCatalogName(), tableRec.getSchemaName(), tableRec.getTableName());
        for (IPrimaryKeyRecord pkRec : pkRecords) {
            RelPrimaryKey pk = new RelPrimaryKey(model, table);
            pk.populateFromRecord(pkRec);
            table.addPrimaryKey(pk);
        }
        model.addTable(table);
    }

    private static final class TableInfo {
        private final String mCatalogName;
        private final String mSchemaName;
        private final String mTableName;

        public TableInfo(String catalogName, String schemaName, String tableName) {
            this.mCatalogName = catalogName;
            this.mSchemaName = schemaName;
            this.mTableName = tableName;
        }

        public String getCatalogName() {
            return this.mCatalogName;
        }

        public String getSchemaName() {
            return this.mSchemaName;
        }

        public String getTableName() {
            return this.mTableName;
        }
    }
}

