/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.rel;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelCrossReference;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelMetadata;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelPrimaryKey;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITableRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.qls.model.physical.rel.AbstractRelMetadata;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelModel;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public final class RelTable
extends AbstractRelMetadata
implements IRelTable {
    private String mCatalogName;
    private String mSchemaName;
    private String mTableName;
    private String mTableType;
    private String mRemarks;

    public RelTable(RelModel model) {
        super(model, (IRelMetadata)null);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.REL_TABLE;
    }

    public String getCatalogName() {
        return this.mCatalogName;
    }

    public void setCatalogName(String catalogName) {
        this.mCatalogName = catalogName;
    }

    public String getSchemaName() {
        return this.mSchemaName;
    }

    public void setSchemaName(String schemaName) {
        this.mSchemaName = schemaName;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public void setTableName(String tableName) {
        this.mTableName = tableName;
    }

    public String getTableType() {
        return this.mTableType;
    }

    public void setTableType(String tableType) {
        this.mTableType = tableType;
    }

    public String getRemarks() {
        return this.mRemarks;
    }

    public void setRemarks(String remarks) {
        this.mRemarks = remarks;
    }

    public List<IRelColumn> getColumns() {
        return this.getChildren(EPhysicalMetadataType.REL_COLUMN, IRelColumn.class);
    }

    public IRelColumn findColumn(String columnName) {
        for (IRelColumn col : this.getChildren(EPhysicalMetadataType.REL_COLUMN, IRelColumn.class)) {
            if (!col.getColumnName().equals(columnName)) continue;
            return col;
        }
        return null;
    }

    public void addColumn(IRelColumn column) {
        this.addChild((IPhysicalMetadata)column);
    }

    public List<IRelPrimaryKey> getPrimaryKeys() {
        return this.getChildren(EPhysicalMetadataType.REL_PRIMARY_KEY, IRelPrimaryKey.class);
    }

    public void addPrimaryKey(IRelPrimaryKey key) {
        this.addChild((IPhysicalMetadata)key);
    }

    public List<IRelCrossReference> getPKCrossReferences() {
        RelModel relModel = (RelModel)this.getModel();
        ArrayList<IRelCrossReference> result = new ArrayList<IRelCrossReference>();
        for (IRelCrossReference xref : relModel.getCrossReferences()) {
            if (xref.getPKTable() != this) continue;
            result.add(xref);
        }
        return result;
    }

    public List<IRelCrossReference> getFKCrossReferences() {
        RelModel relModel = (RelModel)this.getModel();
        ArrayList<IRelCrossReference> result = new ArrayList<IRelCrossReference>();
        for (IRelCrossReference xref : relModel.getCrossReferences()) {
            if (xref.getFKTable() != this) continue;
            result.add(xref);
        }
        return result;
    }

    public void populateFromRecord(ITableRecord record) {
        this.setInternalName(record.getTableName());
        this.setSchemaName(record.getSchemaName());
        this.setCatalogName(record.getCatalogName());
        this.setTableName(record.getTableName());
        this.setTableType(record.getTableType());
        this.setRemarks(record.getRemarks());
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        boolean stableTestOut = Boolean.TRUE.equals(ctx.get((Object)"stableTestOutput"));
        if (null != this.mCatalogName) {
            elem.addElement("catalogName").setText(this.mCatalogName);
        }
        if (null != this.mSchemaName) {
            elem.addElement("schemaName").setText(this.mSchemaName);
        }
        if (null != this.mTableName) {
            if (stableTestOut) {
                elem.addElement("tableName").setText("suppressed-for-mastering");
            } else {
                elem.addElement("tableName").setText(this.mTableName);
            }
        }
        if (null != this.mTableType) {
            elem.addElement("tableType").setText(this.mTableType);
        }
        if (null != this.mRemarks) {
            elem.addElement("remarks").setText(this.mRemarks);
        }
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        Element propElem = elem.element("catalogName");
        this.mCatalogName = null != propElem ? propElem.getText() : null;
        propElem = elem.element("schemaName");
        this.mSchemaName = null != propElem ? propElem.getText() : null;
        propElem = elem.element("tableName");
        this.mTableName = null != propElem ? propElem.getText() : null;
        propElem = elem.element("tableType");
        this.mTableType = null != propElem ? propElem.getText() : null;
        propElem = elem.element("remarks");
        this.mRemarks = null != propElem ? propElem.getText() : null;
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        if (null != this.mCatalogName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mCatalogName);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mSchemaName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mSchemaName);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mTableName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mTableName);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mTableType) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mTableType);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mRemarks) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mRemarks);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mCatalogName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mSchemaName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mTableName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mTableType = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mRemarks = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
    }
}

