/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query;

import com.ibm.cognos.aurora.api.query.IAsyncQuery;
import com.ibm.cognos.aurora.api.query.IAsyncQueryCallback;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.query.data.IResultset;
import com.ibm.cognos.aurora.api.query.queryspec.IQuerySpecification;
import com.ibm.cognos.aurora.qls.query.CancelManager;
import com.ibm.cognos.aurora.qls.query.QueryLogicalStorageImpl;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncQuery
extends CancelManager
implements IAsyncQuery,
Runnable {
    private static final int STATE_RUNNING = 0;
    private static final int STATE_COMPLETED = 1;
    private static final int STATE_FAILED = 2;
    private final QueryLogicalStorageImpl mQLS;
    private final IQuerySpecification mQuerySpec;
    private final ISession mSession;
    private final IAsyncQueryCallback mCallback;
    private final Lock mLock = new ReentrantLock();
    private final Condition mCond = this.mLock.newCondition();
    private volatile int mRunState = 0;
    private volatile IResultset[] mResults = null;
    private volatile Exception mError = null;

    public AsyncQuery(QueryLogicalStorageImpl qls, IQuerySpecification querySpec, ISession session, IAsyncQueryCallback callback) {
        this.mQLS = qls;
        this.mQuerySpec = querySpec;
        this.mSession = session;
        this.mCallback = callback;
    }

    public ISession getSession() {
        return this.mSession;
    }

    public IQuerySpecification getQuerySpec() {
        return this.mQuerySpec;
    }

    public boolean isRunning() {
        return 0 == this.mRunState;
    }

    public boolean isCompleted() {
        return 1 == this.mRunState;
    }

    public boolean isFailed() {
        return 2 == this.mRunState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long nanoTimeout = unit.toNanos(timeout);
        this.mLock.lock();
        try {
            while (this.isRunning()) {
                if (nanoTimeout > 0L) {
                    nanoTimeout = this.mCond.awaitNanos(nanoTimeout);
                    continue;
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mLock.unlock();
        }
        return true;
    }

    public IResultset[] getResults() {
        return this.mResults;
    }

    public Exception getError() {
        return this.mError;
    }

    @Override
    public void run() {
        try {
            IResultset[] results = this.mQLS.queryImpl(this.mQuerySpec, this.mSession, this);
            this.complete(results);
        }
        catch (Exception ex) {
            this.fail(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(IResultset[] results) {
        this.mLock.lock();
        try {
            this.mResults = results;
            this.mRunState = 1;
            this.mCond.signalAll();
            if (null != this.mCallback) {
                this.mCallback.onCompleted((IAsyncQuery)this);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(Exception error) {
        this.mLock.lock();
        try {
            this.mError = error;
            this.mRunState = 2;
            this.mCond.signalAll();
            if (null != this.mCallback) {
                this.mCallback.onFailed((IAsyncQuery)this);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }
}

