/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query;

import com.ibm.cognos.aurora.api.query.ICancelManager;
import com.ibm.cognos.aurora.api.query.ICancelable;
import java.util.Iterator;
import java.util.LinkedList;

public class CancelManager
implements ICancelManager {
    private final ICancelManager mParent;
    private volatile boolean mCanceled = false;
    private final LinkedList<HandlerRegsitration> mHandlers = new LinkedList();

    public CancelManager() {
        this.mParent = null;
    }

    public CancelManager(ICancelManager parent) {
        this.mParent = parent;
        if (null != this.mParent) {
            this.mParent.addCancelHandler((ICancelable)this, true);
        }
    }

    public boolean isCanceled() {
        if (this.mCanceled) {
            return true;
        }
        if (null != this.mParent) {
            return this.mParent.isCanceled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        Iterator iter = this.mHandlers.iterator();
        while (iter.hasNext()) {
            HandlerRegsitration registration = (HandlerRegsitration)iter.next();
            try {
                registration.getHandler().cancel();
            }
            finally {
                if (!registration.isRemovedOnFire()) continue;
                iter.remove();
            }
        }
    }

    public synchronized void addCancelHandler(ICancelable handler, boolean removedOnFire) {
        this.mHandlers.add(new HandlerRegsitration(handler, removedOnFire));
    }

    public synchronized void removeCancelHandler(ICancelable handler) {
        Iterator iter = this.mHandlers.iterator();
        while (iter.hasNext()) {
            HandlerRegsitration registration = (HandlerRegsitration)iter.next();
            if (registration.getHandler() != handler) continue;
            iter.remove();
            break;
        }
    }

    protected final synchronized void clearCancelHandlers() {
        this.mHandlers.clear();
    }

    private static final class HandlerRegsitration {
        final ICancelable mHandler;
        final boolean mRemovedOnFire;

        HandlerRegsitration(ICancelable handler, boolean removedOnFire) {
            this.mHandler = handler;
            this.mRemovedOnFire = removedOnFire;
        }

        ICancelable getHandler() {
            return this.mHandler;
        }

        boolean isRemovedOnFire() {
            return this.mRemovedOnFire;
        }
    }
}

