/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.data;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import java.util.Arrays;

public final class CellCache {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int INITIAL_CACHE_CAPACITY = 128;
    private long[] mOrdinals = new long[128];
    private IValue[] mValues = new IValue[128];
    private int mSize = 0;

    public int size() {
        return this.mSize;
    }

    public long getLastOrdinal() {
        if (0 == this.mSize) {
            return -1L;
        }
        return this.mOrdinals[this.mSize - 1];
    }

    public boolean isOrdinalInRange(long ordinal) {
        return ordinal >= 0L && ordinal <= this.getLastOrdinal();
    }

    public Cursor newCursor() {
        return new Cursor();
    }

    public IValue getValue(long ordinal) throws IndexOutOfBoundsException {
        int limit = this.mSize - 1;
        if (limit >= 0) {
            int position;
            if (ordinal == this.mOrdinals[limit]) {
                return this.mValues[limit];
            }
            if (ordinal < this.mOrdinals[limit] && (position = Arrays.binarySearch(this.mOrdinals, 0, limit, ordinal)) >= 0) {
                return this.mValues[position];
            }
        }
        return null;
    }

    public void putValue(long ordinal, IValue value) {
        if (ordinal <= this.getLastOrdinal()) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "CellCache::putValue() failed, since ordinal is not strictly greater than the previous cell.");
        }
        if (this.mSize >= this.mOrdinals.length) {
            int newSize = Math.max(this.mSize, this.mOrdinals.length * 2);
            long[] newOrdinals = new long[newSize];
            IValue[] newValues = new IValue[newSize];
            System.arraycopy(this.mOrdinals, 0, newOrdinals, 0, this.mOrdinals.length);
            System.arraycopy(this.mValues, 0, newValues, 0, this.mOrdinals.length);
            this.mOrdinals = newOrdinals;
            this.mValues = newValues;
        }
        this.mOrdinals[this.mSize] = ordinal;
        this.mValues[this.mSize] = value;
        ++this.mSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CellCache[");
        for (int i = 0; i < this.mSize; ++i) {
            sb.append(NEWLINE).append(this.mOrdinals[i]).append(": ").append(this.mValues[i]);
        }
        sb.append(NEWLINE).append("]");
        return sb.toString();
    }

    public final class Cursor {
        private int mPosition = -1;

        public boolean isValid() {
            return this.mPosition >= 0 && this.mPosition < CellCache.this.mSize;
        }

        public boolean hasMore() {
            return this.mPosition + 1 < CellCache.this.mSize;
        }

        public boolean next() {
            if (!this.hasMore()) {
                return false;
            }
            ++this.mPosition;
            return true;
        }

        public long getOrdinal() {
            if (!this.isValid()) {
                throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "CellCache.Cursor::getOrdinal() failed, since cursor position was invalid.");
            }
            return CellCache.this.mOrdinals[this.mPosition];
        }

        public IValue getValue() {
            if (!this.isValid()) {
                throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "CellCache.Cursor::getValue() failed, since cursor position was invalid.");
            }
            return CellCache.this.mValues[this.mPosition];
        }
    }
}

