/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.data;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.data.IAxis;
import com.ibm.cognos.aurora.api.query.data.IAxisIterator;
import com.ibm.cognos.aurora.api.query.data.IAxisValue;
import com.ibm.cognos.aurora.api.query.data.IDataPoint;
import com.ibm.cognos.aurora.api.query.data.IResultset;
import com.ibm.cognos.aurora.qls.query.data.DataPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResultSet
implements IResultset {
    private static final DataPointComparator DATAPOINT_COMPARATOR = new DataPointComparator();
    private final IQueryContext queryContext;
    private final IAxis[] axes;
    private final List<IDataPoint> dataPoints;
    protected long[] pageSizes;
    private final DataPoint searchKey = new DataPoint();
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public ResultSet(IQueryContext theQueryContext, IAxis[] theAxes) {
        this.axes = theAxes;
        this.queryContext = theQueryContext;
        this.dataPoints = new ArrayList<IDataPoint>();
    }

    public IQueryContext getQueryContext() {
        return this.queryContext;
    }

    public IAxis[] getAxes() {
        return this.axes;
    }

    public Iterable<IDataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public IValue getValue(long[] axisPositions) {
        if (this.dataPoints.size() == 0) {
            return null;
        }
        long ordinal = this.computeOrdinalFromCoordinates(axisPositions);
        this.searchKey.setOrdinal(ordinal);
        int pos = Collections.binarySearch(this.dataPoints, this.searchKey, DATAPOINT_COMPARATOR);
        if (pos < 0) {
            return null;
        }
        return this.dataPoints.get(pos).getValue();
    }

    public void addDataPoint(DataPoint dataPoint, long[] coordinates) {
        if (this.pageSizes == null) {
            this.computePageSizes();
        }
        long ordinal = this.computeOrdinalFromCoordinates(coordinates);
        dataPoint.setOrdinal(ordinal);
        this.dataPoints.add(dataPoint);
    }

    public void addDataPoint(IDataPoint dataPoint) {
        if (this.pageSizes == null) {
            this.computePageSizes();
        }
        this.dataPoints.add(dataPoint);
    }

    private void computePageSizes() {
        this.pageSizes = new long[this.axes.length];
        for (int i = this.axes.length - 1; i > 0; --i) {
            long otherSetsSize = 1L;
            for (int j = i - 1; j >= 0; --j) {
                otherSetsSize *= (long)this.axes[j].getValues().length;
            }
            this.pageSizes[i] = otherSetsSize;
        }
    }

    protected long computeOrdinalFromCoordinates(long[] coords) {
        long ordinal = 0L;
        for (int i = this.axes.length - 1; i > 0; --i) {
            ordinal += this.pageSizes[i] * coords[i];
        }
        return ordinal += coords[0];
    }

    public void optimize() {
        Collections.sort(this.dataPoints, DATAPOINT_COMPARATOR);
    }

    public String toString() {
        String ls = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        IAxis[] axes = this.getAxes();
        int axisCount = 0;
        for (IAxis dataAxis : axes) {
            sb.append(ls).append("Axis ").append(axisCount++).append(ls);
            int valueIndex = 0;
            for (IAxisValue value : dataAxis.getValues()) {
                sb.append(valueIndex++).append(":").append(value).append(ls);
            }
        }
        sb.append(ls).append("Data points:").append(ls);
        int dpIndex = 0;
        Iterable<IDataPoint> dataPoints = this.getDataPoints();
        for (IDataPoint dp : dataPoints) {
            sb.append(dpIndex++).append(":").append(dp).append(ls);
        }
        return sb.toString();
    }

    public String dumpToString() {
        return this.toString();
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.queryContext.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public int getAxisCount() {
        return this.axes.length;
    }

    public IAxisIterator getAxisIterator(int axis) {
        throw new UnsupportedOperationException();
    }

    public long getAxisCardinality(int axis) {
        return this.axes[axis].getValues().length;
    }

    private static class DataPointComparator
    implements Comparator<IDataPoint> {
        private DataPointComparator() {
        }

        @Override
        public int compare(IDataPoint o1, IDataPoint o2) {
            if (o1.getOrdinal() == o2.getOrdinal()) {
                return 0;
            }
            if (o1.getOrdinal() < o2.getOrdinal()) {
                return -1;
            }
            return 1;
        }
    }
}

