/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.execution.relational;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.StringType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.data.IAttributeValue;
import com.ibm.cognos.aurora.api.query.data.IAxis;
import com.ibm.cognos.aurora.api.query.data.IAxisValue;
import com.ibm.cognos.aurora.api.query.data.IResultset;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularDataProvider;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularResultSet;
import com.ibm.cognos.aurora.api.query.queryspec.IQuerySpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IView;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.QueryLogicalStorageImpl;
import com.ibm.cognos.aurora.qls.query.data.AttributeValue;
import com.ibm.cognos.aurora.qls.query.data.Axis;
import com.ibm.cognos.aurora.qls.query.data.AxisValue;
import com.ibm.cognos.aurora.qls.query.data.DataPoint;
import com.ibm.cognos.aurora.qls.query.data.NodeDecorator;
import com.ibm.cognos.aurora.qls.query.data.ResultSet;
import com.ibm.cognos.aurora.qls.query.execution.IQueryEmitter;
import com.ibm.cognos.aurora.qls.query.execution.ViewExecutor;
import com.ibm.cognos.aurora.qls.query.execution.relational.SQLEmitter;
import com.ibm.cognos.aurora.qls.query.planner.QueryPlanner;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PivotViewExecutor
extends ViewExecutor {
    Map<String, StringValue> metricNameMap = new HashMap<String, StringValue>();

    public PivotViewExecutor(IQueryLogicalStorage qls, QueryPlanner planner, IQuerySpecification querySpec, IQueryContext queryContext) {
        super(qls, planner, querySpec, queryContext);
    }

    private NodeDecorator decorateAttribute(INode attribute, Map<INode, NodeDecorator> decoratorMap) {
        INode category = NavigationHelper.getCategoryFromAttribute((INode)attribute);
        NodeDecorator decorator = decoratorMap.get(attribute);
        if (decorator != null) {
            return decorator;
        }
        boolean canDrillUp = !NavigationHelper.getIsPartOfNodes((INode)category).isEmpty();
        boolean canDrillDown = !NavigationHelper.getPartNodes((INode)category).isEmpty();
        decorator = new NodeDecorator(attribute);
        decorator.setCanDrillUp(canDrillUp);
        decorator.setCanDrillDown(canDrillDown);
        decoratorMap.put(attribute, decorator);
        return decorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResultset execute(IView view) {
        IAssociativeModel model = (IAssociativeModel)this.mQuery.getReferencedModels().iterator().next();
        QuerySpecification querySpecNode = null;
        try {
            PerfLogEvent planEvent = null;
            if (logger.isPerfDebugEnabled()) {
                planEvent = logger.startPerfDebug(this.getClass().getName(), "execute", "Start planning a query");
            }
            querySpecNode = (QuerySpecification)this.mPlanner.plan(model, this.mQuery);
            if (planEvent != null) {
                logger.stopPerfDebug(planEvent, "Finished planning a query");
            }
        }
        catch (Exception e) {
            throw QLSRuntimeException.wrap(e);
        }
        if (logger.isDebugEnabled()) {
            String sqlAst = querySpecNode.dumpToString();
            logger.debug("QuerySpec: \n" + sqlAst, this.getClass().getName() + "::execute()");
        }
        SQLEmitter emitter = new SQLEmitter(querySpecNode, (QueryLogicalStorageImpl)this.mQLS);
        IQueryEmitter.QueryInfo mainQueryInfo = emitter.emit(0);
        if (logger.isDebugEnabled()) {
            logger.debug("Generated SQL: \n " + emitter.getSql(), this.getClass().getName() + "::execute()");
        }
        Map<Integer, List<AxisNodeMap>> map = querySpecNode.getAxisNodesMap();
        int numAxes = map.size();
        IPhysicalModel physModel = view.findPhysicalModel();
        IDataSource dataSource = physModel.getDataSource();
        PerfLogEvent queryEvent = null;
        if (logger.isPerfDebugEnabled()) {
            queryEvent = logger.startPerfDebug(this.getClass().getName(), "execute", "Start querying");
        }
        IProviderManager providerManager = this.mQLS.getProviderManager();
        ITabularDataProvider dataProvider = (ITabularDataProvider)providerManager.getDataProvider("monetdb");
        ITabularResultSet tabularResult = dataProvider.query(dataSource, emitter.getSql(), this.mQueryContext);
        if (queryEvent != null) {
            logger.stopPerfDebug(queryEvent, "Finished querying");
        }
        ArrayList axisValues = new ArrayList();
        ArrayList axisValuesReverseLookupList = new ArrayList();
        LinkedList<Pair> dataPointCoordinates = new LinkedList<Pair>();
        PerfLogEvent pivotEvent = null;
        if (logger.isPerfDebugEnabled()) {
            pivotEvent = logger.startPerfDebug(this.getClass().getName(), "execute", "Starting processing result set");
        }
        try {
            AxisNodeMap[][] axisNodes = new AxisNodeMap[numAxes][];
            long[] axisPositions = new long[numAxes];
            int metricAxis = -1;
            for (int i = 0; i < numAxes; ++i) {
                axisValues.add(new ArrayList());
                List<AxisNodeMap> nodes = querySpecNode.getAxisNodes(i);
                axisNodes[i] = new AxisNodeMap[nodes.size()];
                nodes.toArray(axisNodes[i]);
                axisValuesReverseLookupList.add(new HashMap());
            }
            Map<IDataItem, Integer> columnMapping = mainQueryInfo.getColumnMapping();
            LinkedList<Pair> dataPointToAxisPosition = new LinkedList<Pair>();
            HashMap<INode, NodeDecorator> nodeDecoratorMap = new HashMap<INode, NodeDecorator>();
            while (tabularResult.hasMore()) {
                IValue[] row = tabularResult.nextRow();
                for (int i = 0; i < numAxes; ++i) {
                    AxisValue axisValue = new AxisValue(axisNodes[i].length);
                    int metricPosition = -1;
                    for (int j = 0; j < axisNodes[i].length; ++j) {
                        INode node = axisNodes[i][j].getNode();
                        if (node.isCategory() || node.isAttribute()) {
                            int column = axisNodes[i][j].getColumnNo();
                            INode attribute = node.isAttribute() ? node : NavigationHelper.getDefaultAttributeNode((INode)node);
                            NodeDecorator decorator = this.decorateAttribute(attribute, nodeDecoratorMap);
                            AttributeValue attributeValue = new AttributeValue(decorator, row[column]);
                            axisValue.setValue(attributeValue, j);
                            continue;
                        }
                        metricPosition = j;
                        metricAxis = i;
                    }
                    List currentAxisValues = (List)axisValues.get(i);
                    Map axisValuesReverseLookup = (Map)axisValuesReverseLookupList.get(i);
                    if (metricPosition == -1) {
                        Integer posObj = (Integer)axisValuesReverseLookup.get(axisValue);
                        if (posObj == null) {
                            currentAxisValues.add(axisValue);
                            int pos = currentAxisValues.size() - 1;
                            axisValuesReverseLookup.put(axisValue, pos);
                            axisPositions[i] = pos;
                            continue;
                        }
                        axisPositions[i] = posObj.intValue();
                        continue;
                    }
                    List<INode> metrics = querySpecNode.getMetrics();
                    IAttributeValue[] currentValues = axisValue.getAttributeValues();
                    for (int j = 0; j < metrics.size(); ++j) {
                        NodeDecorator decorator;
                        StringValue value;
                        INode metric = metrics.get(j);
                        IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)metric);
                        String dataItemName = dataItem.getName();
                        int metricOffset = -1;
                        if (j > 0) {
                            axisValue = new AxisValue(axisNodes[i].length);
                            for (int k = 0; k < currentValues.length; ++k) {
                                axisValue.setValue(currentValues[k], k);
                            }
                        }
                        if ((value = this.metricNameMap.get(dataItemName)) == null) {
                            String metricLabel = metric.getLabel();
                            if (metricLabel == null) {
                                metricLabel = NavigationHelper.getDefaultAttributeNode((INode)metric).getLabel();
                            }
                            value = new StringValue(new StringType(metricLabel.length()), metricLabel, ValueStatus.OK);
                            this.metricNameMap.put(dataItemName, value);
                        }
                        if ((decorator = (NodeDecorator)nodeDecoratorMap.get(metric)) == null) {
                            decorator = new NodeDecorator(metric);
                            decorator.setCanDrillDown(false);
                            decorator.setCanDrillUp(false);
                            nodeDecoratorMap.put(metric, decorator);
                        }
                        AttributeValue attValue = new AttributeValue(decorator, (IValue)value);
                        axisValue.setValue(attValue, metricPosition);
                        Integer posObj = (Integer)axisValuesReverseLookup.get(axisValue);
                        if (posObj == null) {
                            currentAxisValues.add(axisValue);
                            metricOffset = currentAxisValues.size() - 1;
                            axisValuesReverseLookup.put(axisValue, metricOffset);
                        } else {
                            metricOffset = posObj;
                        }
                        DataPoint dataPoint = new DataPoint();
                        dataPoint.setValue(row[columnMapping.get(dataItem)]);
                        dataPointToAxisPosition.add(new Pair((Object)dataPoint, (Object)metricOffset));
                    }
                }
                for (Pair pair : dataPointToAxisPosition) {
                    axisPositions[metricAxis] = ((Integer)pair.getSecond()).intValue();
                    long[] coord = new long[axisPositions.length];
                    System.arraycopy(axisPositions, 0, coord, 0, axisPositions.length);
                    dataPointCoordinates.add(new Pair(pair.getFirst(), (Object)coord));
                }
                dataPointToAxisPosition.clear();
            }
        }
        finally {
            tabularResult.close();
        }
        IAxis[] resultAxes = new IAxis[numAxes];
        ResultSet resultSet = new ResultSet(this.mQueryContext, resultAxes);
        for (int i = 0; i < numAxes; ++i) {
            List iv = (List)axisValues.get(i);
            IAxisValue[] v = new IAxisValue[iv.size()];
            v = iv.toArray(v);
            resultAxes[i] = new Axis(v, i);
        }
        for (Pair pair : dataPointCoordinates) {
            resultSet.addDataPoint((DataPoint)pair.getFirst(), (long[])pair.getSecond());
        }
        resultSet.optimize();
        if (pivotEvent != null) {
            logger.stopPerfDebug(pivotEvent, "Finished processing result set");
        }
        return resultSet;
    }
}

