/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.execution.relational;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.core.util.StringSubstitutionEngine;
import com.ibm.cognos.aurora.qls.query.QueryLogicalStorageImpl;
import com.ibm.cognos.aurora.qls.query.execution.IQueryEmitter;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.ISQLQueryNode;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAbstractFunction;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAggregate;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAlias;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLDataType;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLDistinct;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLFilter;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLGroupBy;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLGroupByList;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLHaving;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLIn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLiteral;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLogical;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLPartition;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLProduct;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLProject;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRangeVar;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRelation;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRowLimit;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSort;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSortKey;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSortKeyList;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLValueList;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLWindow;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecification;
import java.util.Map;

public class SQLEmitter
implements IQueryEmitter {
    public static final String PROPERTY_COLUMN_MAPPING = "mapping";
    protected final QueryLogicalStorageImpl qls;
    private final StringBuilder sBuilder = new StringBuilder();
    private Map<IDataItem, Integer> mapping;
    private final QuerySpecification querySpec;

    public SQLEmitter(QuerySpecification querySpecNode, QueryLogicalStorageImpl qlsImpl) {
        this.querySpec = querySpecNode;
        this.qls = qlsImpl;
    }

    private SQLEmitter(SQLEmitter visitor) {
        this.qls = visitor.qls;
        this.mapping = visitor.mapping;
        this.querySpec = visitor.querySpec;
    }

    public void visit(SQLAbstractFunction node) {
        int nParameters = node.getNumberParameters();
        String[] argValues = new String[nParameters];
        for (int i = 0; i < nParameters; ++i) {
            SQLEmitter visitor = new SQLEmitter(this);
            ((ISQLQueryNode)node.getChild(i)).accept(visitor);
            argValues[i] = visitor.getSql();
        }
        this.sBuilder.append(String.format(node.getPattern(), argValues));
    }

    public void visit(SQLAggregate node) {
        this.visit((SQLAbstractFunction)node);
        ISQLQueryNode window = (ISQLQueryNode)node.getWindow();
        if (null != window) {
            window.accept(this);
        }
    }

    public void visit(SQLAlias node) {
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        this.sBuilder.append(" AS \"").append(node.getName()).append("\"");
    }

    public void visit(SQLColumn node) {
        String tableName = node.getTableName();
        String name = node.getName();
        if (tableName != null) {
            this.sBuilder.append("\"").append(tableName).append("\".");
        }
        this.sBuilder.append("\"").append(name).append("\"");
    }

    public void visit(SQLDataType node) {
        this.sBuilder.append(node.getDataType().toString().toUpperCase());
    }

    public void visit(SQLDistinct node) {
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        this.sBuilder.append("DISTINCT ");
    }

    public void visit(SQLFilter node) {
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        this.sBuilder.append(" WHERE ");
        node.getPredicate().accept(this);
    }

    public void visit(SQLGroupBy node) {
        node.getOutputList().accept(this);
        this.sBuilder.append(" FROM ");
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        if (node.getGroupByList() != null) {
            this.sBuilder.append(" GROUP BY ");
            node.getGroupByList().accept(this);
        }
    }

    public void visit(SQLGroupByList node) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.sBuilder.append(", ");
            }
            ((ISQLQueryNode)node.getChild(i)).accept(this);
        }
    }

    public void visit(SQLHaving node) {
    }

    public void visit(SQLIn node) {
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        this.sBuilder.append(" IN (");
        ((ISQLQueryNode)node.getChild(1)).accept(this);
        this.sBuilder.append(")");
    }

    public void visit(SQLLiteral node) {
        this.sBuilder.append("'").append(StringSubstitutionEngine.escapeSQLString((String)node.getValue().stringValue())).append("'");
    }

    public void visit(SQLLogical node) {
        int nParameters = node.getNumberParameters();
        String[] argValues = new String[nParameters];
        for (int i = 0; i < nParameters; ++i) {
            SQLEmitter visitor = new SQLEmitter(this);
            ((ISQLQueryNode)node.getChild(i)).accept(visitor);
            argValues[i] = visitor.getSql();
        }
        ISQLQueryNode parent = (ISQLQueryNode)node.getParent();
        boolean needBracket = false;
        if (node.getSubType() == SQLLogical.SubType.OR && parent.getNodeType() == 3019 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.AND || node.getSubType() == SQLLogical.SubType.AND && parent.getNodeType() == 3019 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.OR) {
            needBracket = true;
        }
        if (needBracket) {
            this.sBuilder.append("(");
        }
        this.sBuilder.append(String.format(node.getPattern(), argValues));
        if (needBracket) {
            this.sBuilder.append(")");
        }
    }

    public void visit(SQLPartition node) {
    }

    public void visit(SQLProduct node) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.sBuilder.append(", ");
            }
            ((ISQLQueryNode)node.getChild(i)).accept(this);
        }
    }

    public void visit(SQLProject node) {
        node.getOutputList().accept(this);
        this.sBuilder.append(" FROM ");
        ((ISQLQueryNode)node.getChild(0)).accept(this);
    }

    public void visit(SQLRangeVar node) {
        ISQLQueryNode child = (ISQLQueryNode)node.getChild(0);
        if (child.getNodeType() == 3024) {
            child.accept(this);
        } else {
            this.sBuilder.append(" (SELECT ");
            child.accept(this);
            this.sBuilder.append(")");
        }
        this.sBuilder.append(" \"").append(node.getName()).append("\"");
    }

    public void visit(SQLRelation node) {
        String schema = node.getSchemaName();
        if (schema != null) {
            this.sBuilder.append("\"").append(schema).append("\".");
        }
        this.sBuilder.append("\"").append(node.getTableName()).append("\"");
    }

    public void visit(SQLRowLimit node) {
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        this.sBuilder.append(" LIMIT ");
        this.sBuilder.append(node.getRowLimit().stringValue());
    }

    public void visit(SQLSelect node) {
        this.sBuilder.append("SELECT ");
        ((ISQLQueryNode)node.getChild(0)).accept(this);
    }

    public void visit(SQLSort node) {
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        this.sBuilder.append(" ORDER BY ");
        node.getSortKeyList().accept(this);
    }

    public void visit(SQLSortKey node) {
        ((ISQLQueryNode)node.getChild(0)).accept(this);
        if (!node.isAscending()) {
            this.sBuilder.append(" DESC");
        }
    }

    public void visit(SQLSortKeyList node) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.sBuilder.append(", ");
            }
            ((ISQLQueryNode)node.getChild(i)).accept(this);
        }
    }

    public void visit(SQLValueList node) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.sBuilder.append(", ");
            }
            ((ISQLQueryNode)node.getChild(i)).accept(this);
        }
    }

    public void visit(SQLWindow node) {
        this.sBuilder.append(" OVER (");
        ISQLQueryNode orderBy = (ISQLQueryNode)node.getOrderBy();
        if (null != orderBy) {
            this.sBuilder.append("ORDER BY ");
            orderBy.accept(this);
        }
        this.sBuilder.append(")");
    }

    public String getSql() {
        return this.sBuilder.toString();
    }

    public void reset() {
        this.sBuilder.setLength(0);
    }

    @Override
    public IQueryEmitter.QueryInfo emit(int queryNum) {
        this.reset();
        SQLSelect sqlSelect = (SQLSelect)this.querySpec.getChild(queryNum);
        this.visit(sqlSelect);
        return new IQueryEmitter.QueryInfo(this.sBuilder.toString(), sqlSelect.getColumnMapping());
    }

    @Override
    public int getNumQueries() {
        return this.querySpec.getNumberChildren();
    }
}

