/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.AbstractMDXLevel;

public class BaseLevel
extends AbstractMDXLevel {
    public static final String PROP_LEVEL_UNIQUE_NAME = "levelUniqueName";

    @Override
    public int getType() {
        return 2008;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 2008) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public boolean isSameExpression(IXQEQueryNode node) {
        boolean status = false;
        if (this.getType() == node.getType()) {
            String thisLUN = this.getLevelUniqueName();
            String otherLUN = ((BaseLevel)node).getLevelUniqueName();
            status = null == thisLUN ? null == otherLUN : thisLUN.equals(otherLUN);
        }
        return status;
    }

    public int isValidPlannedQuery() {
        int status = this.getId();
        if (this.getLevelUniqueName() != null && this.getNumberChildren() == 0) {
            status = -1;
        }
        return status;
    }

    public int getMinimumNumberChildren() {
        return 0;
    }

    public String[] getSyntaxProperties() {
        return new String[]{PROP_LEVEL_UNIQUE_NAME};
    }

    public String getLevelUniqueName() {
        return (String)this.getPropertyValue(PROP_LEVEL_UNIQUE_NAME);
    }

    public void setLevelUniqueName(String levelUniqueName) {
        this.setPropertyValue(PROP_LEVEL_UNIQUE_NAME, levelUniqueName);
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("ci", -1);
        trace.attribute("type", "qs:level");
        String lun = this.getLevelUniqueName();
        if (lun != null) {
            trace.data(lun);
        }
        trace.endElement();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getLevelUniqueName());
    }
}

