/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberReference;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXQuery;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.OLAPQueryNode;
import java.util.ArrayList;
import java.util.List;

public class MDXCalculatedMemberDefinition
extends OLAPQueryNode {
    public static final String PROP_CALC_MEMBER_REFS = "calcMemberRefs";
    public static final String PROP_CUSTOM_SOLVE_ORDER = "solveOrder";
    public static final String PROP_CUSTOM_UNIQUE_NAME = "member";
    public static final String PROP_CUSTOM_PREFIX = "prefix";
    public static final String PROP_CUSTOM_CAPTION = "caption";
    public static final String PROP_HIERARCHY = "hierarchy";
    protected static final String PROP_NAME = "name";

    public MDXCalculatedMemberDefinition() {
        this.setPropertyValue(PROP_CUSTOM_SOLVE_ORDER, XQEIntegerPool.getInteger((int)0));
        this.setPropertyValue(PROP_CALC_MEMBER_REFS, new ArrayList());
    }

    public int getType() {
        return 2027;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("calculatedMember", -1);
        if (this.getSolveOrder() != 0) {
            trace.attribute(PROP_CUSTOM_SOLVE_ORDER, this.getSolveOrder());
        }
        trace.beginElement("ci", -1);
        trace.attribute("type", "qs:member");
        String externalName = this.getExternalName();
        if (externalName != null) {
            trace.data(externalName);
        } else {
            trace.data(this.getUniqueName());
        }
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        if (this.getCaption() != null && this.getCaption().length() != 0) {
            trace.beginElement("propertyDefinition", -1);
            trace.beginElement("ci", -1);
            trace.attribute("type", "qs:property");
            trace.data("memberCaption");
            trace.endElement();
            trace.beginElement("cn", -1);
            trace.attribute("type", "xsd:string");
            trace.data(this.getCaption());
            trace.endElement();
            trace.endElement();
        }
        trace.endElement();
    }

    public int getSolveOrder() {
        return (Integer)this.getPropertyValue(PROP_CUSTOM_SOLVE_ORDER);
    }

    public String getExternalName() {
        return (String)this.getPropertyValue("externalName");
    }

    public void generateUniqueName(MDXQuery query) {
        IOlapHierarchy hierarchy = this.getHierarchy();
        if (query == null || hierarchy == null || this.getPrefix() == null) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        String uniqueName = query.createCalculatedMemberUniqueName(hierarchy, this.getPrefix());
        this.setPropertyValue(PROP_CUSTOM_UNIQUE_NAME, uniqueName);
    }

    public void generateUniqueName() {
        this.generateUniqueName((MDXQuery)this.getAncestorOfType(2000));
    }

    public String getUniqueName() {
        return (String)this.getPropertyValue(PROP_CUSTOM_UNIQUE_NAME);
    }

    public void addCalcMemberRef(MDXCalculatedMemberReference calcRef) {
        ((List)this.getPropertyValue(PROP_CALC_MEMBER_REFS)).add(calcRef);
        calcRef.getPlanningEnvironment().setTreeHasBeenModified();
    }

    public void setPrefix(String prefix) {
        this.setPropertyValue(PROP_CUSTOM_PREFIX, prefix);
    }

    public String getPrefix() {
        return (String)this.getPropertyValue(PROP_CUSTOM_PREFIX);
    }

    public String getCaption() {
        return (String)this.getPropertyValue(PROP_CUSTOM_CAPTION);
    }

    public void setCaption(String caption) {
        this.setPropertyValue(PROP_CUSTOM_CAPTION, caption);
    }

    private IOlapHierarchy getHierarchy() {
        return (IOlapHierarchy)this.getPropertyValue(PROP_HIERARCHY);
    }

    public void setHierarchy(IOlapHierarchy hierarchy) {
        if (this.getHierarchy() != null) {
            this.setPropertyValue(PROP_HIERARCHY, hierarchy);
            this.generateUniqueName();
        } else {
            this.setPropertyValue(PROP_HIERARCHY, hierarchy);
        }
    }

    public void setName(String name) {
        this.setPropertyValue(PROP_NAME, name);
    }

    public String getName() {
        return (String)this.getPropertyValue(PROP_NAME);
    }
}

