/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.AbstractMDXSetOperator;
import java.util.Iterator;

public class MDXDescendants
extends AbstractMDXSetOperator {
    protected static final String NODE_CUSTOM_PROPERTY_RANGE_ID = "rangeId";
    private static final String BEFORE_FLAG_WITH_MEMBERS = "beforeFlagWithMembers";
    public static final int SELF = 0;
    public static final int BEFORE = 1;
    public static final int AFTER = 2;
    public static final int BEFORE_AND_AFTER = 3;
    public static final int SELF_AND_AFTER = 4;
    public static final int SELF_AND_BEFORE = 5;
    public static final int SELF_BEFORE_AFTER = 6;

    @Override
    public int getType() {
        return 2050;
    }

    public void setRangeFlag(int range) {
        this.setPropertyValue(NODE_CUSTOM_PROPERTY_RANGE_ID, XQEIntegerPool.getInteger((int)range));
    }

    public int getRangeFlag() {
        Integer range = this.getIntegerPropertyValue(NODE_CUSTOM_PROPERTY_RANGE_ID);
        if (range == null) {
            this.throwInternalError("Range flag not set.");
        }
        return range;
    }

    public void dumpExtraInfo(XQETrace trace) {
        trace.attribute("rangeString", this.getMDXRangeFlagString());
    }

    private String getMDXRangeFlagString() {
        switch (this.getRangeFlag()) {
            case 0: {
                return "SELF";
            }
            case 1: {
                return "BEFORE";
            }
            case 2: {
                return "AFTER";
            }
            case 3: {
                return "BEFORE_AND_AFTER";
            }
            case 4: {
                return "SELF_AND_AFTER";
            }
            case 5: {
                return "SELF_AND_BEFORE";
            }
            case 6: {
                return "SELF_BEFORE_AFTER";
            }
        }
        return null;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        boolean includeMember = this.getBooleanPropertyValue(BEFORE_FLAG_WITH_MEMBERS);
        int range = this.getRangeFlag();
        if (range == 1 || range == 3 || range == 5 || range == 6) {
            // empty if block
        }
        if (!includeMember) {
            buffer.append("EXCEPT");
            buffer.append("(");
        }
        buffer.append("DESCENDANTS");
        buffer.append("(");
        boolean isFirst = true;
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            ((IXQEQueryNode)childIterator.next()).writeFormattedText(buffer);
        }
        if (this.getRangeFlag() != 0) {
            buffer.append(", ");
            buffer.append(this.getMDXRangeFlagString());
        }
        buffer.append(")");
        if (!includeMember) {
            buffer.append(", ");
            buffer.append("{");
            this.getChild(0).writeFormattedText(buffer);
            buffer.append("}");
            buffer.append(")");
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("descendantSet", -1);
        trace.endElement();
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            ((IXQEQueryNode)childIterator.next()).dumpFormattedXMLQuery(trace);
        }
        String beforeFlag = "before";
        if (this.getPropertyValue(BEFORE_FLAG_WITH_MEMBERS) != null && ((Boolean)this.getPropertyValue(BEFORE_FLAG_WITH_MEMBERS)).booleanValue()) {
            beforeFlag = "beforeWithMember";
        }
        switch (this.getRangeFlag()) {
            case 1: {
                this.addMDQueryRangeFlag(trace, beforeFlag);
                break;
            }
            case 2: {
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
            case 3: {
                this.addMDQueryRangeFlag(trace, beforeFlag);
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
            case 4: {
                this.addMDQueryRangeFlag(trace, "self");
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
            case 5: {
                this.addMDQueryRangeFlag(trace, "self");
                this.addMDQueryRangeFlag(trace, beforeFlag);
                break;
            }
            case 6: {
                this.addMDQueryRangeFlag(trace, "self");
                this.addMDQueryRangeFlag(trace, beforeFlag);
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
        }
        trace.endElement();
    }

    public void setWithMembersInBeforeFlag(boolean withMembers) {
        this.setPropertyValue(BEFORE_FLAG_WITH_MEMBERS, withMembers);
    }

    private void addMDQueryRangeFlag(XQETrace trace, String option) {
        trace.beginElement("cn", -1);
        trace.attribute("type", "xsd:string");
        trace.data(option);
        trace.endElement();
    }
}

