/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.OLAPQueryNode;

public class MDXFromCube
extends OLAPQueryNode {
    public static final String PROP_OLAP_MODEL = "olapModel";
    public static final String PROP_CATALOG_NAME = "catalogName";
    public static final String PROP_CUBE_NAME = "cubeName";

    public IOlapModel getOlapModel() {
        return (IOlapModel)this.getPropertyValue(PROP_OLAP_MODEL);
    }

    public void setOlapModel(IOlapModel model) {
        this.setPropertyValue(PROP_OLAP_MODEL, model);
    }

    public int getType() {
        return 2001;
    }

    public boolean isOfCategory(int category) {
        if (category == 2001) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public boolean isSameExpression(IXQEQueryNode node) {
        boolean status = false;
        if (this.getType() == node.getType()) {
            String thisCubeName = this.getCubeName();
            String otherCubeName = ((MDXFromCube)node).getCubeName();
            if (null == thisCubeName) {
                status = null == otherCubeName;
            } else {
                return thisCubeName.equals(otherCubeName);
            }
        }
        return status;
    }

    public int isValidPlannedQuery() {
        IXQEQueryNode parent;
        int status = this.getId();
        if (this.getCubeName() != null && this.getNumberChildren() == 0 && (parent = this.getParent()) != null && parent.getType() == 2000) {
            status = -1;
        }
        return status;
    }

    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    public int getMinimumNumberChildren() {
        return 0;
    }

    public IDataSource getDataSource() {
        return this.getOlapModel().getDataSource();
    }

    public void setCubeName(String cubeName) {
        this.setPropertyValue(PROP_CUBE_NAME, cubeName);
    }

    public String getCubeName() {
        return (String)this.getPropertyValue(PROP_CUBE_NAME);
    }

    public void setCatalogName(String catalogName) {
        this.setPropertyValue(PROP_CATALOG_NAME, catalogName);
    }

    public String getCatalogName() {
        return (String)this.getPropertyValue(PROP_CATALOG_NAME);
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        String cubeName;
        String catalogName = this.getCatalogName();
        if (null != catalogName) {
            trace.beginElement("ci", -1);
            trace.attribute("type", "qs:catalog");
            trace.data(catalogName);
            trace.endElement();
        }
        if (null == (cubeName = this.getCubeName())) {
            this.throwInternalError("Cube name was missing.");
        }
        trace.beginElement("ci", -1);
        trace.attribute("type", "qs:cube");
        trace.data(cubeName);
        trace.endElement();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        String cubeName = this.getCubeName();
        boolean appendBrackets = false;
        if (!cubeName.startsWith("[")) {
            appendBrackets = true;
        }
        buffer.append("\n");
        buffer.append("FROM");
        buffer.append(" ");
        if (appendBrackets) {
            buffer.append("[");
        }
        buffer.append(cubeName);
        if (appendBrackets) {
            buffer.append("]");
        }
        buffer.append(" ");
    }
}

