/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.AbstractMDXNumericValueExpression;
import java.math.BigDecimal;

public class MDXNumericConstant
extends AbstractMDXNumericValueExpression {
    public static final String PROP_VALUE = "value";

    @Override
    public int getType() {
        return 2015;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 2015) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public int isValidPlannedQuery() {
        int status = this.getId();
        if (this.getNumberChildren() == 0) {
            return -1;
        }
        return status;
    }

    public int getMinimumNumberChildren() {
        return 0;
    }

    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    public boolean isSameExpression(IXQEQueryNode node) {
        if (this.getType() == node.getType() && this.getConstantValue().equals(((MDXNumericConstant)node).getConstantValue())) {
            return super.isSameExpression(node);
        }
        return false;
    }

    public String[] getSyntaxProperties() {
        return new String[]{PROP_VALUE};
    }

    public void setConstantValue(Number value) {
        this.setPropertyValue(PROP_VALUE, value);
    }

    public Number getConstantValue() {
        return (Number)this.getPropertyValue(PROP_VALUE);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getConstantValue().toString());
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        Number num = this.getConstantValue();
        String type = null;
        trace.beginElement("cn", -1);
        if (num instanceof Double) {
            type = "xsd:double";
        } else if (num instanceof Integer || num instanceof BigDecimal) {
            type = "xsd:integer";
        } else if (num instanceof Long) {
            type = "xsd:long";
        } else {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Unsupported numeric type: " + num.getClass().toString());
        }
        trace.attribute("type", type);
        trace.data(num.toString());
        trace.endElement();
    }
}

