/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.AbstractMDXValueExpression;
import java.util.Iterator;

public class MDXNumericOperator
extends AbstractMDXValueExpression {
    public static final String CUSTOM_PROPERTY_OPERATOR = "operator";
    public static final int NUM_OP_MINUS = 0;
    public static final int NUM_OP_PLUS = 1;
    public static final int NUM_OP_DIVIDE = 2;
    public static final int NUM_OP_MULTIPLY = 3;
    public static final int NUM_OP_UNARY_PLUS = 4;
    public static final int NUM_OP_UNARY_MINUS = 5;

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        int operatorType = this.getOperatorProperty();
        trace.beginElement("apply", -1);
        if (operatorType != 4) {
            trace.beginElement(this.getMDOperatorName(), -1);
            trace.endElement();
        }
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            ((IXQEQueryNode)childIterator.next()).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        if (this.getNumberChildren() == 2) {
            buffer.append("(");
            this.getChild(0).writeFormattedText(buffer);
            buffer.append(this.getMDXOperatorName());
            if (this.getOperatorProperty() == 2) {
                StringBuilder tempbuf = new StringBuilder();
                this.getChild(1).writeFormattedText(tempbuf);
                if (tempbuf.indexOf("(") == 0) {
                    buffer.append((CharSequence)tempbuf);
                } else {
                    buffer.append("(");
                    buffer.append((CharSequence)tempbuf);
                    buffer.append(")");
                }
            } else {
                this.getChild(1).writeFormattedText(buffer);
            }
            buffer.append(")");
        } else {
            buffer.append(this.getMDXOperatorName());
            this.getChild(0).writeFormattedText(buffer);
        }
    }

    private String getMDXOperatorName() {
        String mdxOperatorName = null;
        int operatorType = this.getOperatorProperty();
        switch (operatorType) {
            case 0: {
                mdxOperatorName = "-";
                break;
            }
            case 1: {
                mdxOperatorName = "+";
                break;
            }
            case 3: {
                mdxOperatorName = "*";
                break;
            }
            case 2: {
                mdxOperatorName = "/";
                break;
            }
            case 4: {
                mdxOperatorName = "+";
                break;
            }
            case 5: {
                mdxOperatorName = "-";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return mdxOperatorName;
    }

    public void setOperatorProperty(int value) {
        this.setPropertyValue(CUSTOM_PROPERTY_OPERATOR, value);
    }

    public int getOperatorProperty() {
        return (Integer)this.getPropertyValue(CUSTOM_PROPERTY_OPERATOR);
    }

    private String getMDOperatorName() {
        String mdOperatorName = null;
        int operatorType = this.getOperatorProperty();
        switch (operatorType) {
            case 0: {
                mdOperatorName = "minus";
                break;
            }
            case 1: {
                mdOperatorName = "plus";
                break;
            }
            case 3: {
                mdOperatorName = "times";
                break;
            }
            case 2: {
                mdOperatorName = "divide";
                break;
            }
            case 4: {
                mdOperatorName = "plus";
                break;
            }
            case 5: {
                mdOperatorName = "minus";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return mdOperatorName;
    }

    @Override
    public int getType() {
        return 2037;
    }
}

