/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.api.query.queryspec.actions.ISortKey;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.AbstractMDXSetOperator;
import java.util.Iterator;

public class MDXOrder
extends AbstractMDXSetOperator {
    protected static final String PROPERTY_ORDERING = "ordering";
    public static final int ORDERING_ASC = 0;
    public static final int ORDERING_BASC = 1;
    public static final int ORDERING_DESC = 2;
    public static final int ORDERING_BDESC = 3;

    @Override
    public int getType() {
        return 2022;
    }

    public int getOrderingProperty() {
        return (Integer)this.getPropertyValue(PROPERTY_ORDERING);
    }

    public void setOrderingProperty(int type) {
        this.setPropertyValue(PROPERTY_ORDERING, XQEIntegerPool.getInteger((int)type));
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("ORDER");
        buffer.append("(");
        boolean isFirst = true;
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            ((IXQEQueryNode)childIterator.next()).writeFormattedText(buffer);
        }
        buffer.append(", ");
        buffer.append(this.getMDXOrderingName());
        buffer.append(")");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("orderSet", -1);
        trace.endElement();
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            ((IXQEQueryNode)childIterator.next()).dumpFormattedXMLQuery(trace);
        }
        trace.beginElement("cn", -1);
        trace.attribute("type", "xsd:string");
        trace.data(this.getMDOrderingName());
        trace.endElement();
        trace.beginElement("cn", -1);
        trace.attribute("type", "xsd:boolean");
        if (this.getMDOrderingHierarchical()) {
            trace.data("true");
        } else {
            trace.data("false");
        }
        trace.endElement();
        trace.endElement();
    }

    private String getMDXOrderingName() {
        String mdxFunctionName = null;
        int operatorType = this.getOrderingProperty();
        switch (operatorType) {
            case 0: {
                mdxFunctionName = "ASC";
                break;
            }
            case 1: {
                mdxFunctionName = "BASC";
                break;
            }
            case 2: {
                mdxFunctionName = "DESC";
                break;
            }
            case 3: {
                mdxFunctionName = "BDESC";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return mdxFunctionName;
    }

    private String getMDOrderingName() {
        String mdFunctionName = null;
        int operatorType = this.getOrderingProperty();
        switch (operatorType) {
            case 0: 
            case 1: {
                mdFunctionName = "ascending";
                break;
            }
            case 2: 
            case 3: {
                mdFunctionName = "descending";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return mdFunctionName;
    }

    private boolean getMDOrderingHierarchical() {
        boolean isHierarchized = false;
        int operatorType = this.getOrderingProperty();
        switch (operatorType) {
            case 0: 
            case 2: {
                isHierarchized = true;
                break;
            }
            case 1: 
            case 3: {
                isHierarchized = false;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return isHierarchized;
    }

    public static int determineSortType(ISortKey key) {
        int sortType = 1;
        if (key != null) {
            return MDXOrder.determineSortType(key.isAscending(), key.isHierarchical());
        }
        return sortType;
    }

    public static int determineSortType(boolean ascending, boolean keepHierarchy) {
        int sortType = 1;
        sortType = ascending ? (keepHierarchy ? 0 : 1) : (keepHierarchy ? 2 : 3);
        return sortType;
    }
}

