/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.query.provider.dim.IMDQuery;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCellProperties;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXEdge;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXFromCube;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.OLAPQueryNode;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class MDXQuery
extends OLAPQueryNode
implements IMDQuery {
    public static final String PROP_IS_MDQUERY_SPEC = "IS_MDQUERY_SPEC";
    public static final String PROP_IS_BLUENOSE = "IS_BLUENOSE";
    public static final String PROP_IS_PXJ_ENABLED = "IS_PXJ_ENABLED";
    public static final String PROP_INCLUDE_CALCULATED_MEMBERS = "INCLUDE_CALCULATED_MEMBERS";
    public static final String PROP_NULL_EXPRESSION_BEHAVIOR = "NULL_EXPRESSION_BEHAVIOR";
    public static final String PROP_NULL_SUPPRESSION_QUERY_HINT = "NULL_SUPPRESSION_QUERY_HINT";
    public static final String AURORA_PREFIX = "AURORA";
    public static final String CALC_MEMBER = "_CM";
    public static final int MDX_IDENTIFIER_MAXIMUM_LENGTH = 98;
    public static final String CLOSE_SQUARE_BRACKET = "]";
    public static final String DOT_OPEN_SQUARE_BRACKET = ".[";
    private static final String AT_MEMBER = ".[@MEMBER]";
    public static final String AXIS_TUPLE_LIMITS_PROPERTY = "axisTupleLimits";
    private int latestCalculatedMemberId = -1;
    private int latestNamedSetId = -1;
    private int latestSetAliasId = -1;
    private int latestCachingId = 0;

    public MDXQuery() {
        this.setPropertyValue("cellProperties", new MDXCellProperties());
    }

    public int getType() {
        return 2000;
    }

    public boolean isOfCategory(int category) {
        if (category == 2006) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public MDXCellProperties getCellProperties() {
        return (MDXCellProperties)this.getPropertyValue("cellProperties");
    }

    public void addCellProperty(String cellProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getCellProperties().addCellProperty(cellProperty);
    }

    public void removeCellProperty(String cellProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getCellProperties().removeCellProperty(cellProperty);
    }

    public void clearCellProperties() {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getCellProperties().clearCellProperties();
    }

    public int getNextCalculatedMemberId() {
        return ++this.latestCalculatedMemberId;
    }

    public int getNextNamedSetId() {
        return ++this.latestNamedSetId;
    }

    public int getNextSetAliasId() {
        return ++this.latestSetAliasId;
    }

    public int getNextCachingId() {
        return ++this.latestCachingId;
    }

    public MDXFromCube getMDXFrom() {
        MDXFromCube fromCube = (MDXFromCube)this.getFirstChildByType(2001);
        if (fromCube == null) {
            this.throwInternalError("Unable to find the child MDXFromCube node.");
        }
        return fromCube;
    }

    public int getNumberOfEdges() {
        return this.getEdges().length;
    }

    public int getNumberOfEdgesWithChildren() {
        int edgeWithChildrenCount = 0;
        for (MDXEdge currEdge : this.getEdges()) {
            if (currEdge.getNumberChildren() == 0) continue;
            ++edgeWithChildrenCount;
        }
        return edgeWithChildrenCount;
    }

    public MDXEdge[] getEdges() {
        ArrayList<MDXEdge> edges = new ArrayList<MDXEdge>();
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = (IXQEQueryNode)childIterator.next();
            if (child.getType() != 2002) continue;
            edges.add((MDXEdge)child);
        }
        return edges.toArray(new MDXEdge[edges.size()]);
    }

    public int getEdgeOrdinal(MDXEdge edge) {
        MDXEdge[] edges = this.getEdges();
        for (int edgeIndex = 0; edgeIndex < edges.length; ++edgeIndex) {
            if (edges[edgeIndex] != edge) continue;
            return edgeIndex;
        }
        throw new QLSRuntimeException(CoreMessageKeys.PLN_PlanFailed);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode child;
        int idx = 0;
        int i = 0;
        int nChildren = this.getNumberChildren();
        boolean withClauseDone = false;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 2027) continue;
            if (withClauseDone) {
                buffer.append("\n");
                buffer.append("  ");
                child.writeFormattedText(buffer);
                continue;
            }
            withClauseDone = true;
            buffer.append("WITH");
            buffer.append("\n");
            buffer.append("  ");
            child.writeFormattedText(buffer);
        }
        if (withClauseDone) {
            buffer.append("\n");
        }
        buffer.append("SELECT");
        buffer.append(" ");
        i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 2002) continue;
            if (i++ > 0) {
                buffer.append(", ");
                buffer.append("\n");
                buffer.append("  ");
            } else {
                buffer.append("\n");
                buffer.append("  ");
            }
            child.writeFormattedText(buffer);
        }
        this.getMDXFrom().writeFormattedText(buffer);
        i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 2039) continue;
            if (i++ == 0) {
                buffer.append("\n");
            }
            child.writeFormattedText(buffer);
        }
        i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (i++ == 0) {
                buffer.append("\n");
            }
            child.writeFormattedText(buffer);
        }
        i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (i++ == 0) {
                buffer.append("\n");
            }
            child.writeFormattedText(buffer);
        }
        MDXCellProperties cellProperties = (MDXCellProperties)this.getPropertyValue("cellProperties");
        cellProperties.writeFormattedText(buffer);
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("md:MDQuerySpec", -1);
        trace.attribute("xmlns:md", "http://developer.cognos.com/schemas/mds/1/");
        trace.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = (IXQEQueryNode)childIterator.next();
            if (child.getType() == 2001) continue;
            child.dumpFormattedXMLQuery(trace);
        }
        this.getCellProperties().dumpFormattedXMLQuery(trace);
        this.getMDXFrom().dumpFormattedXMLQuery(trace);
        trace.endElement();
    }

    public IDataSource getDataSource() {
        MDXFromCube mdxFrom = this.getMDXFrom();
        return mdxFrom.getDataSource();
    }

    public String getProviderType() {
        IDataSource dataSource = this.getDataSource();
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        return connSpec.getParameterStringValue("providerType");
    }

    public String getCatalogName() {
        MDXFromCube mdxFrom = this.getMDXFrom();
        return mdxFrom.getCatalogName();
    }

    public String getCubeName() {
        MDXFromCube mdxFrom = this.getMDXFrom();
        return mdxFrom.getCubeName();
    }

    public String getQueryString() {
        if (this.isMDQuerySpec()) {
            StringWriter writer = new StringWriter();
            XQETrace trace = new XQETrace();
            trace.addStream((Writer)writer);
            this.dumpFormattedXMLQuery(trace);
            return writer.toString();
        }
        StringBuilder sb = new StringBuilder();
        this.writeFormattedText(sb);
        return sb.toString();
    }

    public boolean isMDQuerySpec() {
        return this.getBooleanPropertyValue(PROP_IS_MDQUERY_SPEC, Boolean.FALSE);
    }

    public void setMDQuerySpec(boolean isMDQuerySpec) {
        this.setPropertyValue(PROP_IS_MDQUERY_SPEC, isMDQuerySpec);
    }

    public boolean isBluenose() {
        return this.getBooleanPropertyValue(PROP_IS_BLUENOSE, Boolean.FALSE);
    }

    public void setBluenose(boolean isBluenose) {
        this.setPropertyValue(PROP_IS_BLUENOSE, isBluenose);
    }

    public boolean getIncludeCalculatedMembers() {
        return this.getBooleanPropertyValue(PROP_INCLUDE_CALCULATED_MEMBERS, Boolean.FALSE);
    }

    public void setIncludeCalculatedMembers(boolean includeCalculatedMembers) {
        this.setPropertyValue(PROP_INCLUDE_CALCULATED_MEMBERS, includeCalculatedMembers);
    }

    public String getNullExpressionBehavior() {
        return (String)this.getPropertyValue(PROP_NULL_EXPRESSION_BEHAVIOR);
    }

    public void setNullExpressionBehavior(String nullExpressionBehavior) {
        this.setPropertyValue(PROP_NULL_EXPRESSION_BEHAVIOR, nullExpressionBehavior);
    }

    public String getNullSuppressionQueryHint() {
        return (String)this.getPropertyValue(PROP_NULL_SUPPRESSION_QUERY_HINT);
    }

    public void setNullSuppressionQueryHint(String nullSuppressionQueryHint) {
        this.setPropertyValue(PROP_NULL_SUPPRESSION_QUERY_HINT, nullSuppressionQueryHint);
    }

    public boolean isPXJEnabled() {
        return this.getBooleanPropertyValue(PROP_IS_PXJ_ENABLED, Boolean.FALSE);
    }

    public void setPXJEnabled(boolean isPXJEnabled) {
        this.setPropertyValue(PROP_IS_PXJ_ENABLED, isPXJEnabled);
    }

    public int getExpectedEdgeCount() {
        return this.getChildrenOfType(2002).length;
    }

    public String createCalculatedMemberUniqueName(IOlapHierarchy hierarchy, String name) {
        String suffix = this.createMDXIdentifier(AURORA_PREFIX, name, CALC_MEMBER + this.getNextCalculatedMemberId());
        StringBuffer strBuf = new StringBuffer(hierarchy.getUniqueName());
        strBuf.append(AT_MEMBER);
        strBuf.append(DOT_OPEN_SQUARE_BRACKET).append(suffix).append(CLOSE_SQUARE_BRACKET);
        return strBuf.toString();
    }

    public String createMDXIdentifier(String prefix, String name, String suffix) {
        StringBuilder strBuf = new StringBuilder(prefix);
        if (prefix.length() + name.length() + suffix.length() < 98) {
            strBuf.append(name);
        } else {
            int iMaxNameLength = 98 - prefix.length() - suffix.length();
            strBuf.append(name.substring(0, iMaxNameLength - 1));
        }
        strBuf.append(suffix);
        return strBuf.toString().replace('[', '_').replace(']', '_');
    }
}

