/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.EOperator;
import com.ibm.cognos.aurora.qls.query.execution.relational.SQLEmitter;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAbstractFunction;

public class SQLValueExpression
extends SQLAbstractFunction {
    private static final String PROP_ENUM_SUBTYPE = "subType";

    public int getType() {
        return 3030;
    }

    @Override
    public void accept(SQLEmitter visitor) {
        visitor.visit(this);
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    public void setSubType(EOperator operator) {
        switch (operator) {
            case NEGATE: {
                this.setSubType(SubType.NEGATE);
                break;
            }
            case PLUS: {
                this.setSubType(SubType.ADD);
                break;
            }
            case MINUS: {
                this.setSubType(SubType.SUBTRACT);
                break;
            }
            case MULTIPLY: {
                this.setSubType(SubType.MULTIPLY);
                break;
            }
            case DIVIDE: {
                this.setSubType(SubType.DIVIDE);
                break;
            }
            case CONCAT: {
                this.setSubType(SubType.CONCATENATE);
                break;
            }
        }
    }

    @Override
    public String getFunctionName() {
        return this.getSubType().key();
    }

    @Override
    public String getPattern() {
        return this.getSubType().getPattern();
    }

    public static enum SubType {
        NEGATE("Negate", 1, "-%s"),
        UNARYPLUS("UnaryPlus", 1, "+%s"),
        MULTIPLY("Multiply", 2, "%s * %s"),
        DIVIDE("Divide", 2, "%s / %s"),
        SAFE_DIVIDE("SafeDivide", 2, "%s / %s"),
        ADD("Add", 3, "%s + %s"),
        SUBTRACT("Subtract", 3, "%s - %s"),
        CONCATENATE("Concat", 3, "%s || %s");

        private String key;
        private String pattern;
        private int precedence;

        private SubType(String theKey, int thePrecedence, String thePattern) {
            this.key = theKey;
            this.precedence = thePrecedence;
            this.pattern = thePattern;
        }

        String key() {
            return this.key;
        }

        public int precedence() {
            return this.precedence;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

