/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IContext;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.QueryHierarchyOLAP;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.ContextDependentRule;

public class AddDefaultMeasureToContext
extends ContextDependentRule {
    public AddDefaultMeasureToContext() {
        this.mName = "Replace FilterByData with the top/bottom count function.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{30, 25, 21, 14};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        IContext contextNode = (IContext)node;
        if (contextNode.getDefaultMeasureUniqueName() != null) {
            this.traceNodeCondition(true, "Measure is already defined in context.", environment.getTrace());
            return false;
        }
        boolean foundMeasure = false;
        for (IMember member : contextNode.getContext()) {
            if (!member.getHierarchy().isValues()) continue;
            foundMeasure = true;
            break;
        }
        if (foundMeasure) {
            this.traceNodeCondition(true, "Measure is already defined in context.", environment.getTrace());
            return false;
        }
        this.traceNodeCondition(true, "The default measure needs to be added to the context.", environment.getTrace());
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IContext contextNode = (IContext)node;
        contextNode.setDefaultMeasureUniqueName(this.getDefaultMeasure(node));
    }

    private String getDefaultMeasure(IXQEQueryNode node) {
        IXQEQueryNode spec = this.getSpec(node);
        if (spec == null) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "No Set or Axis specification found for node " + node.getId());
        }
        IXQEQueryNode[] selections = spec.getDescendantsOfType(4, false);
        if (selections.length == 0) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        if (selections[0].getType() != 4) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        IHierarchy selectionHierarchy = ((ISelectionSpecification)selections[0]).getHierarchy();
        IOlapHierarchy valuehierarchy = null;
        if (selectionHierarchy.isValues()) {
            if (!(selectionHierarchy instanceof QueryHierarchyOLAP)) {
                throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
            }
            valuehierarchy = (IOlapHierarchy)selectionHierarchy;
        } else {
            if (!(selectionHierarchy instanceof QueryHierarchyOLAP)) {
                throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
            }
            QueryHierarchyOLAP olapHierarchy = (QueryHierarchyOLAP)selectionHierarchy;
            valuehierarchy = olapHierarchy.getOLAPHierarchy().getCube().getMeasureDimension().getDefaultHierarchy();
        }
        return valuehierarchy.getDefaultMember().getUniqueName();
    }
}

