/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.query.queryspec.IAxisSpecification;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.model.QueryHierarchyOLAP;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberDefinition;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberReference;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXQuery;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.CreateMDXCalculatedMember;

public class ConvertAxisAggregateOptionToCalculatedMember
extends CreateMDXCalculatedMember {
    public ConvertAxisAggregateOptionToCalculatedMember() {
        this.mName = "Converts an Axis Aggregate option into a Calculated Member.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{2};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        IAxisSpecification axis = (IAxisSpecification)node;
        if (axis.getOption(IAxisSpecification.AxisOption.AGGREGATE) == null || !((Boolean)axis.getOption(IAxisSpecification.AxisOption.AGGREGATE)).booleanValue()) {
            this.traceNodeCondition(false, "Axis option \"Aggregate\" not set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "AxisSpecification selection needs to be converted to a Calculated member.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] setSpecs;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (IXQEQueryNode setSpec : setSpecs = node.getDescendantsOfType(3, false)) {
            for (IXQEQueryNode selectionSpec : setSpec.getDescendantsOfType(4, false)) {
                IXQEQueryNode selectionSpecCopy = nodeFactory.copyNode(selectionSpec);
                MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(2000);
                MDXCalculatedMemberReference calcMemberReference = this.createCalculatedMember(nodeFactory, ((QueryHierarchyOLAP)selectionSpec.getPropertyValue("hierarchy")).getOLAPHierarchy(), mdxQuery);
                MDXCalculatedMemberDefinition calcMemberDefinition = calcMemberReference.getDefinition();
                IXQEQueryNode mdxSummaryFunction = nodeFactory.createNode(2053);
                calcMemberDefinition.addChild(mdxSummaryFunction);
                selectionSpec.move(mdxSummaryFunction);
                mdxQuery.addChild(calcMemberDefinition, 0);
                setSpec.addChild(selectionSpecCopy);
                selectionSpecCopy.addChild((IXQEQueryNode)calcMemberReference);
            }
        }
        ((IAxisSpecification)node).setOption(IAxisSpecification.AxisOption.AGGREGATE, (Object)false);
    }
}

