/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.ICalculation;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.QueryHierarchyOLAP;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberDefinition;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberReference;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXQuery;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.CreateMDXCalculatedMember;
import com.ibm.cognos.aurora.qls.query.queryspec.Calculation;
import com.ibm.cognos.aurora.qls.query.queryspec.Count;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionNode;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import java.util.HashMap;

public class ConvertCalculationToMDXCalculatedMember
extends CreateMDXCalculatedMember {
    public ConvertCalculationToMDXCalculatedMember() {
        this.mName = "Convert a Calculation to an MDXCalculatedMember.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{2044};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        this.traceNodeCondition(true, "Calculation selection needs to be converted to a MDXCalculatedMember.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Calculation calculation = (Calculation)node;
        IXQEQueryNode mdxQuery = node.getAncestorOfType(2000);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXCalculatedMemberReference calcMemberRef = this.createCalculatedMember(nodeFactory, ((QueryHierarchyOLAP)calculation.getHierarchy()).getOLAPHierarchy(), (MDXQuery)mdxQuery);
        MDXCalculatedMemberDefinition calcMemberDef = calcMemberRef.getDefinition();
        mdxQuery.addChild((IXQEQueryNode)calcMemberDef, 0);
        if (!(calculation.getHierarchy() instanceof QueryHierarchyOLAP)) {
            throw new QLSRuntimeException(QLSMessageKeys.EXE_UnsupportedDrillContext);
        }
        IXQEQueryNode querySpecNode = node.getAncestorOfType(0);
        IOlapHierarchy physicalHierarchy = ((QueryHierarchyOLAP)calculation.getHierarchy()).getOLAPHierarchy();
        calcMemberDef.setHierarchy(physicalHierarchy);
        calcMemberDef.setPrefix("");
        calcMemberDef.setName(calculation.getUniqueName());
        calcMemberDef.generateUniqueName();
        HashMap<String, Calculation> calculationNameMap = (HashMap<String, Calculation>)querySpecNode.getPropertyValue("calculationMappings");
        if (calculationNameMap == null) {
            calculationNameMap = new HashMap<String, Calculation>();
            querySpecNode.setPropertyValue("calculationMappings", calculationNameMap);
        }
        calculationNameMap.put(calcMemberDef.getUniqueName(), calculation);
        this.createMDXCalculation(nodeFactory, calculation, calcMemberDef);
        calculation.extract();
    }

    private void createMDXCalculation(XQENodeFactory nodeFactory, ICalculation calculation, MDXCalculatedMemberDefinition calcMemberDef) {
        IXQEQueryNode mdxCountNode = nodeFactory.createNode(2029);
        calcMemberDef.addChild(mdxCountNode, 0);
        Count count = (Count)calculation;
        for (ISelectionAction selectionAction : count.getSelection().getSelectionActions()) {
            ((SelectionActionNode)selectionAction).move(mdxCountNode);
        }
        ((SelectionSpecification)count.getSelection()).detach();
    }
}

