/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertContextInExpressionToMeasure
extends OLAPQueryRule {
    public ConvertContextInExpressionToMeasure() {
        this.mName = "Convert a member in context to an MDX measure";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{14};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertContextInExpressionToMeasure.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        if (((ISetFunction)node).getContext() == null) {
            this.traceNodeCondition(false, "Node has no context member", trace);
            return false;
        }
        if (node.getFirstChildByType(2010) != null) {
            this.traceNodeCondition(false, "The baseMember has already been created.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The node has member in context.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IMember[] members;
        ISetFunction setFunction = (ISetFunction)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (setFunction.getContext() == null || setFunction.getContext().length != 1) {
            throw new UnsupportedOperationException();
        }
        for (IMember member : members = setFunction.getContext()) {
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(member.getUniqueName());
            baseMember.setMeasure(member.getHierarchy().isValues());
            node.addChild((IXQEQueryNode)baseMember);
        }
    }
}

