/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXDescendants;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionExpandMembersToDepth;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;

public class ConvertExpandMembersToDepthToMDXDescendants
extends OLAPQueryRule {
    public ConvertExpandMembersToDepthToMDXDescendants() {
        this.mName = "Convert ExpandMembersToDepth to MDX Descendants function.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{32};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertExpandMembersToDepthToMDXDescendants.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Member selection needs to be converted to a BaseMeasure.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionSpecification selection = (SelectionSpecification)node.getAncestorOfType(4);
        IHierarchy hierarchy = selection.getHierarchy();
        SelectionActionExpandMembersToDepth expandToDepth = (SelectionActionExpandMembersToDepth)node;
        int depth = expandToDepth.getDepth();
        if (depth < 0 || depth >= hierarchy.getLevels().size()) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_InvalidHierarchyDepth, Integer.valueOf(depth).toString(), (Object)hierarchy.getCaption());
        }
        MDXDescendants descendantsFunction = (MDXDescendants)nodeFactory.createNode(2050);
        this.wrapCurrentSelection(node, descendantsFunction, nodeFactory);
        descendantsFunction.addChild(this.createLevelsFunction(nodeFactory, hierarchy, depth));
        descendantsFunction.setRangeFlag(5);
        descendantsFunction.setWithMembersInBeforeFlag(true);
    }

    private IXQEQueryNode createLevelsFunction(XQENodeFactory nodeFactory, IHierarchy hierarchy, int depth) {
        MDXNumericConstant constantNode = (MDXNumericConstant)nodeFactory.createNode(2015);
        constantNode.setConstantValue(depth);
        IXQEQueryNode levels = nodeFactory.createNode(2009);
        BaseHierarchy baseHierarchy = (BaseHierarchy)nodeFactory.createNode(2012);
        baseHierarchy.setHierarchyUniqueName(hierarchy.getUniqueName());
        baseHierarchy.setPropertyValue("membersProjected", Boolean.TRUE);
        levels.addChild((IXQEQueryNode)baseHierarchy);
        levels.addChild((IXQEQueryNode)constantNode);
        return levels;
    }
}

