/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXLevels;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXMembers;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionExpandToDepth;

public class ConvertExpandToDepthToLevelsSelection
extends OLAPQueryRule {
    private static final String SUPPRESS_MEMBERS_PROJECTION = "suppressMembersProjection";

    public ConvertExpandToDepthToLevelsSelection() {
        this.mName = "Convert ExpandToDepth to levels selection.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{27};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertExpandToDepthToLevelsSelection.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Member selection needs to be converted to a BaseMeasure.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ISelectionSpecification selection = (ISelectionSpecification)node.getAncestorOfType(4);
        IHierarchy hierarchy = selection.getHierarchy();
        SelectionActionExpandToDepth expandToDepth = (SelectionActionExpandToDepth)node;
        int depth = expandToDepth.getDepth();
        if (depth < 0 || depth >= hierarchy.getLevels().size()) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_InvalidHierarchyDepth, Integer.valueOf(depth).toString(), (Object)hierarchy.getCaption());
        }
        this.removeAllChildNodesBefore(parent, parent.getPositionOfChild(node));
        IXQEQueryNode hierarchize = nodeFactory.createNode(2017);
        IXQEQueryNode aSet = nodeFactory.createNode(2004);
        hierarchize.addChild(aSet);
        for (int i = 0; i <= depth; ++i) {
            MDXMembers mdxMembersNode = (MDXMembers)nodeFactory.createNode(2006, node);
            MDXLevels mdxLevelsNode = (MDXLevels)nodeFactory.createNode(2009, (IXQEQueryNode)mdxMembersNode);
            mdxMembersNode.addChild(mdxLevelsNode);
            BaseHierarchy baseHierNode = (BaseHierarchy)nodeFactory.createNode(2012, (IXQEQueryNode)mdxLevelsNode);
            baseHierNode.setHierarchyUniqueName(hierarchy.getUniqueName());
            baseHierNode.setPropertyValue(SUPPRESS_MEMBERS_PROJECTION, Boolean.TRUE);
            MDXNumericConstant depthConstNode = (MDXNumericConstant)nodeFactory.createNode(2015, (IXQEQueryNode)mdxLevelsNode);
            depthConstNode.setConstantValue(i);
            mdxLevelsNode.addChild(baseHierNode);
            mdxLevelsNode.addChild(depthConstNode);
            aSet.addChild((IXQEQueryNode)mdxMembersNode);
        }
        node.exchange(hierarchize);
    }
}

