/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXAnd;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXTuple;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.ContextDependentRule;

public class ConvertFilterOnRangeToFilterMDXFunction
extends ContextDependentRule {
    public ConvertFilterOnRangeToFilterMDXFunction() {
        this.mName = "Replace FilterOnRange with the MDX Filter function.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{25};
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxFilter = nodeFactory.createNode(2034);
        this.wrapSetsOrSelections(node, mdxFilter, nodeFactory);
        Double from = (Double)node.getPropertyValue("FROM");
        Double to = (Double)node.getPropertyValue("TO");
        if (from == null && to == null) {
            throw new IllegalStateException();
        }
        if (from != null && to != null) {
            MDXAnd and = (MDXAnd)nodeFactory.createNode(2035);
            and.addChild(this.generateFromExpression(node, nodeFactory, from));
            and.addChild(this.generateToExpression(node, nodeFactory, to));
            mdxFilter.addChild((IXQEQueryNode)and);
        } else if (from != null) {
            mdxFilter.addChild(this.generateFromExpression(node, nodeFactory, from));
        } else {
            mdxFilter.addChild(this.generateToExpression(node, nodeFactory, to));
        }
    }

    private IXQEQueryNode generateFromExpression(IXQEQueryNode filterOnRange, XQENodeFactory nodeFactory, Double from) {
        MDXTuple mdxTuple = this.constructContextTuple(filterOnRange, nodeFactory);
        MDXNumericConstant constant = (MDXNumericConstant)nodeFactory.createNode(2015);
        constant.setConstantValue(from);
        return this.generateComparisonExpression(6, nodeFactory, mdxTuple, constant);
    }

    private IXQEQueryNode generateToExpression(IXQEQueryNode filterOnRange, XQENodeFactory nodeFactory, Double to) {
        MDXTuple mdxTuple = this.constructContextTuple(filterOnRange, nodeFactory);
        MDXNumericConstant constant = (MDXNumericConstant)nodeFactory.createNode(2015);
        constant.setConstantValue(to);
        return this.generateComparisonExpression(6, nodeFactory, constant, mdxTuple);
    }
}

