/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXHeadTailFunction;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class ConvertHeadTailToMDXHeadTailFunction
extends OLAPQueryRule {
    public ConvertHeadTailToMDXHeadTailFunction() {
        this.mName = "Convert Head/Tail to the MDX Head/Tail function";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{14};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertHeadTailToMDXHeadTailFunction.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        SetFunction setFunction = (SetFunction)node;
        ESetFunction functionType = setFunction.getFunctionType();
        if (functionType == ESetFunction.HEAD || functionType == ESetFunction.TAIL) {
            this.traceNodeCondition(true, "The head/tail function needs to be converted to the MDX Head/Tail count", trace);
            return true;
        }
        this.traceNodeCondition(false, "The node is not a head/tail function.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SetFunction setFunction = (SetFunction)node;
        MDXHeadTailFunction mdxHeadTail = (MDXHeadTailFunction)nodeFactory.createNode(2031);
        switch (setFunction.getFunctionType()) {
            case HEAD: {
                mdxHeadTail.setOperatorType(1);
                break;
            }
            case TAIL: {
                mdxHeadTail.setOperatorType(2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.wrapCurrentSelection(node, mdxHeadTail, nodeFactory);
        IXQEQueryNode countConstant = setFunction.getChild(0);
        countConstant.move((IXQEQueryNode)mdxHeadTail);
    }
}

