/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.query.queryspec.expression.ILiteralNode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertLiteralNodeToMDXNumericConstant
extends OLAPQueryRule {
    public ConvertLiteralNodeToMDXNumericConstant() {
        this.mName = "ConvertLiteralNodeToMDXNumericConstant";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{11};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertLiteralNodeToMDXNumericConstant.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        ILiteralNode literal = (ILiteralNode)node;
        if (literal.getValue().getType().isNumeric()) {
            this.traceNodeCondition(true, "A numeric literal needs to be converted to an MDX numeric constant.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The literal does not represent a numeric constant.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXNumericConstant numericConstant = (MDXNumericConstant)nodeFactory.createNode(2015);
        ILiteralNode literal = (ILiteralNode)node;
        numericConstant.setConstantValue(literal.getValue().numberValue());
        node.exchange((IXQEQueryNode)numericConstant, true);
    }
}

