/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.ICalculation;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ESelectionActionOperationType;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMembersSelection;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberDefinition;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberReference;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXExcept;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXIntersect;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionMembers;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;

public class ConvertMemberToMDXMember
extends OLAPQueryRule {
    public ConvertMemberToMDXMember() {
        this.mName = "Convert a Members selection to a MDX Measure.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{2041};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertMemberToMDXMember.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        IMembersSelection membersSelection = (IMembersSelection)node;
        IMember[] members = membersSelection.getMembers();
        if (members == null || members.length == 0) {
            this.traceNodeCondition(true, "No member to be converted.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Member selection needs to be converted to a BaseMeasure.", trace);
        return true;
    }

    private void selectionSetMembers(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        IMembersSelection membersSelection = (IMembersSelection)node;
        IXQEQueryNode parent = node.getParent();
        this.removeAllChildNodesBefore(parent, parent.getPositionOfChild(node));
        IMember[] members = membersSelection.getMembers();
        int insertPos = 0;
        for (IMember member : members) {
            if (member instanceof ICalculation) {
                this.convertCalculationRef((ICalculation)member, nodeFactory, (SelectionActionMembers)membersSelection);
                continue;
            }
            String mun = member.getUniqueName();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(member.getHierarchy().isValues());
            parent.addChild((IXQEQueryNode)baseMember, insertPos++);
        }
        node.detach();
    }

    private void selectionAddMembers(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        IMember[] members;
        IMembersSelection membersSelection = (IMembersSelection)node;
        IXQEQueryNode setNode = nodeFactory.createNode(2004);
        this.wrapCurrentSelection(node, setNode, nodeFactory);
        for (IMember member : members = membersSelection.getMembers()) {
            if (member instanceof ICalculation) {
                this.convertCalculationRef((ICalculation)member, nodeFactory, (SelectionActionMembers)membersSelection);
                continue;
            }
            String mun = member.getUniqueName();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(member.getHierarchy().isValues());
            setNode.addChild((IXQEQueryNode)baseMember);
        }
        IXQEQueryNode distinctNode = nodeFactory.createNode(2049);
        setNode.insertParent(distinctNode);
    }

    private void selectionRemoveMembers(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        IMember[] members;
        IMembersSelection membersSelection = (IMembersSelection)node;
        MDXExcept exceptNode = (MDXExcept)nodeFactory.createNode(2047);
        exceptNode.setAll(true);
        this.wrapCurrentSelection(node, exceptNode, nodeFactory);
        IXQEQueryNode setNode = nodeFactory.createNode(2004);
        exceptNode.addChild(setNode);
        for (IMember member : members = membersSelection.getMembers()) {
            if (member instanceof ICalculation) {
                this.convertCalculationRef((ICalculation)member, nodeFactory, (SelectionActionMembers)membersSelection);
                continue;
            }
            String mun = member.getUniqueName();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(member.getHierarchy().isValues());
            setNode.addChild((IXQEQueryNode)baseMember);
        }
    }

    private void selectionKeepMembers(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        IMember[] members;
        IMembersSelection membersSelection = (IMembersSelection)node;
        MDXIntersect intersectNode = (MDXIntersect)nodeFactory.createNode(2048);
        intersectNode.setAll(true);
        this.wrapCurrentSelection(node, intersectNode, nodeFactory);
        IXQEQueryNode setNode = nodeFactory.createNode(2004);
        intersectNode.addChild(setNode);
        for (IMember member : members = membersSelection.getMembers()) {
            if (member instanceof ICalculation) {
                this.convertCalculationRef((ICalculation)member, nodeFactory, (SelectionActionMembers)membersSelection);
                continue;
            }
            String mun = member.getUniqueName();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(member.getHierarchy().isValues());
            setNode.addChild((IXQEQueryNode)baseMember);
        }
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IMembersSelection membersSelection = (IMembersSelection)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ESelectionActionOperationType operationType = membersSelection.getOperationType();
        switch (operationType) {
            case ADD: {
                this.selectionAddMembers(node, nodeFactory);
                break;
            }
            case REMOVE: {
                this.selectionRemoveMembers(node, nodeFactory);
                break;
            }
            case KEEP: {
                this.selectionKeepMembers(node, nodeFactory);
                break;
            }
            default: {
                this.selectionSetMembers(node, nodeFactory);
            }
        }
    }

    private void convertCalculationRef(ICalculation calculationRef, XQENodeFactory nodeFactory, SelectionActionMembers selection) {
        IXQEQueryNode mdxQuery = selection.getAncestorOfType(2000);
        boolean foundDefinition = false;
        int insertPos = 0;
        for (IXQEQueryNode child : mdxQuery.getChildrenOfType(2027)) {
            MDXCalculatedMemberDefinition cmDef = (MDXCalculatedMemberDefinition)child;
            if (!cmDef.getName().equals(calculationRef.getName())) continue;
            this.validateCalculationSpec(calculationRef, selection);
            MDXCalculatedMemberReference calcMemberRef = (MDXCalculatedMemberReference)nodeFactory.createNode(2028);
            calcMemberRef.bind(cmDef);
            selection.getParent().addChild((IXQEQueryNode)calcMemberRef, insertPos++);
            foundDefinition = true;
        }
        if (!foundDefinition) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "No children of type MDX_CALC_MEMBER_DEFINITION were found");
        }
    }

    private void validateCalculationSpec(ICalculation calculation, SelectionActionMembers selection) {
        if (calculation.getHierarchy() != ((SelectionSpecification)selection.getParent()).getHierarchy()) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Calculation hierarchy is not consistent with selection hierarchy");
        }
    }
}

