/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ESelectionActionOperationType;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMembersByDepth;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXExcept;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXIntersect;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXLevels;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXMembers;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertMembersByDepthToLevelsFunction
extends OLAPQueryRule {
    private static final String SUPPRESS_MEMBERS_PROJECTION = "suppressMembersProjection";

    public ConvertMembersByDepthToLevelsFunction() {
        this.mName = "Convert MembersByDepth to levels selection.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{29};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertMembersByDepthToLevelsFunction.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Member selection needs to be converted to a BaseMeasure.", trace);
        return true;
    }

    private IXQEQueryNode createLevelMembersNode(IXQEQueryNode node, XQENodeFactory nodeFactory, IHierarchy hierarchy) {
        IMembersByDepth membersByDepth = (IMembersByDepth)node;
        MDXMembers mdxMembersNode = (MDXMembers)nodeFactory.createNode(2006, node);
        MDXLevels mdxLevelsNode = (MDXLevels)nodeFactory.createNode(2009, (IXQEQueryNode)mdxMembersNode);
        mdxMembersNode.addChild(mdxLevelsNode);
        BaseHierarchy baseHierNode = (BaseHierarchy)nodeFactory.createNode(2012, (IXQEQueryNode)mdxLevelsNode);
        baseHierNode.setHierarchyUniqueName(hierarchy.getUniqueName());
        baseHierNode.setPropertyValue(SUPPRESS_MEMBERS_PROJECTION, Boolean.TRUE);
        MDXNumericConstant depthConstNode = (MDXNumericConstant)nodeFactory.createNode(2015, (IXQEQueryNode)mdxLevelsNode);
        depthConstNode.setConstantValue(membersByDepth.getDepth());
        mdxLevelsNode.addChild(baseHierNode);
        mdxLevelsNode.addChild(depthConstNode);
        return mdxMembersNode;
    }

    private void selectionSetMembers(IXQEQueryNode node, XQENodeFactory nodeFactory, IHierarchy hierarchy) {
        IXQEQueryNode parent = node.getParent();
        this.removeAllChildNodesBefore(parent, parent.getPositionOfChild(node));
        parent.addChild(this.createLevelMembersNode(node, nodeFactory, hierarchy));
        node.detach();
    }

    private void selectionAddMembers(IXQEQueryNode node, XQENodeFactory nodeFactory, IHierarchy hierarchy) {
        IXQEQueryNode setNode = nodeFactory.createNode(2004);
        this.wrapCurrentSelection(node, setNode, nodeFactory);
        setNode.addChild(this.createLevelMembersNode(node, nodeFactory, hierarchy));
        IXQEQueryNode distinctNode = nodeFactory.createNode(2049);
        setNode.insertParent(distinctNode);
    }

    private void selectionRemoveMembers(IXQEQueryNode node, XQENodeFactory nodeFactory, IHierarchy hierarchy) {
        MDXExcept exceptNode = (MDXExcept)nodeFactory.createNode(2047);
        exceptNode.setAll(true);
        this.wrapCurrentSelection(node, exceptNode, nodeFactory);
        exceptNode.addChild(this.createLevelMembersNode(node, nodeFactory, hierarchy));
    }

    private void selectionKeepMembers(IXQEQueryNode node, XQENodeFactory nodeFactory, IHierarchy hierarchy) {
        MDXIntersect intersectNode = (MDXIntersect)nodeFactory.createNode(2048);
        intersectNode.setAll(true);
        this.wrapCurrentSelection(node, intersectNode, nodeFactory);
        intersectNode.addChild(this.createLevelMembersNode(node, nodeFactory, hierarchy));
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IMembersByDepth membersByDepth = (IMembersByDepth)node;
        ISelectionSpecification selection = (ISelectionSpecification)node.getAncestorOfType(4);
        IHierarchy hierarchy = selection.getHierarchy();
        int depth = membersByDepth.getDepth();
        if (depth < 0 || depth >= hierarchy.getLevels().size()) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_InvalidHierarchyDepth, Integer.valueOf(depth).toString(), (Object)hierarchy.getCaption());
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ESelectionActionOperationType operationType = membersByDepth.getOperationType();
        switch (operationType) {
            case ADD: {
                this.selectionAddMembers(node, nodeFactory, hierarchy);
                break;
            }
            case REMOVE: {
                this.selectionRemoveMembers(node, nodeFactory, hierarchy);
                break;
            }
            case KEEP: {
                this.selectionKeepMembers(node, nodeFactory, hierarchy);
                break;
            }
            default: {
                this.selectionSetMembers(node, nodeFactory, hierarchy);
            }
        }
    }
}

