/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertSelectAllToMDXHierarchy
extends OLAPQueryRule {
    public ConvertSelectAllToMDXHierarchy() {
        this.mName = "Convert an All selection to a MDX Hierarchy.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{18};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertSelectAllToMDXHierarchy.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SelectionActionAll needs to be converted to a BaseHierarchy.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode calcMemberDef = node.getAncestorOfType(2027);
        if (calcMemberDef != null) {
            IOlapHierarchy hierarchy = (IOlapHierarchy)calcMemberDef.getPropertyValue("hierarchy");
            String hun = hierarchy.getUniqueName();
            BaseHierarchy baseHierarchyNode = (BaseHierarchy)nodeFactory.createNode(2012, node);
            baseHierarchyNode.setHierarchyUniqueName(hun);
            node.exchange((IXQEQueryNode)baseHierarchyNode, true);
            return;
        }
        ISelectionSpecification selection = (ISelectionSpecification)node.getAncestorOfType(4);
        IHierarchy hierarchy = selection.getHierarchy();
        String hun = hierarchy.getUniqueName();
        BaseHierarchy baseHierarchyNode = (BaseHierarchy)nodeFactory.createNode(2012, node);
        baseHierarchyNode.setHierarchyUniqueName(hun);
        node.exchange((IXQEQueryNode)baseHierarchyNode, true);
    }
}

