/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXDefaultMember;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertSelectDefaultValueToMDXDefaultMember
extends OLAPQueryRule {
    public ConvertSelectDefaultValueToMDXDefaultMember() {
        this.mName = "Convert an All selection to a MDX Hierarchy.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{19};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertSelectDefaultValueToMDXDefaultMember.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Default value selection needs to be converted to a MDXDefaultMember", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ISelectionSpecification selection = (ISelectionSpecification)node.getParent();
        INode[] businessHierarchy = selection.getBusinessHierarchy();
        if (businessHierarchy != null) {
            throw new IllegalStateException();
        }
        IHierarchy hierarchy = selection.getHierarchy();
        String hun = hierarchy.getUniqueName();
        MDXDefaultMember defaultMember = (MDXDefaultMember)nodeFactory.createNode(2021);
        BaseHierarchy baseHierarchyNode = (BaseHierarchy)nodeFactory.createNode(2012, node);
        baseHierarchyNode.setHierarchyUniqueName(hun);
        baseHierarchyNode.setPropertyValue("membersProjected", Boolean.TRUE);
        defaultMember.addChild(baseHierarchyNode);
        node.exchange((IXQEQueryNode)defaultMember, true);
    }
}

