/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.ESortDirection;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXOrder;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXTuple;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.ContextDependentRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SortByData;

public class ConvertSelectionActionSortByDataToOrderMDXFunction
extends ContextDependentRule {
    public ConvertSelectionActionSortByDataToOrderMDXFunction() {
        this.mName = "Replace selection action SortByData with the MDX Order function.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{21};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getParent().getType() == 4) {
            this.traceNodeCondition(true, "The SortByData selection action needs to be converted to an MDX Order.", trace);
            return true;
        }
        this.traceNodeCondition(true, "The SortByData node is not a selection action.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXOrder mdxOrder = (MDXOrder)nodeFactory.createNode(2022, node);
        this.wrapCurrentSelection(node, mdxOrder, nodeFactory);
        MDXTuple mdxTuple = this.constructContextTuple(node, nodeFactory);
        mdxOrder.addChild(mdxTuple);
        SortByData sortNode = (SortByData)node;
        int sortType = MDXOrder.determineSortType(sortNode.getSortDirection() == ESortDirection.Ascending, sortNode.isKeepHierarchy());
        mdxOrder.setOrderingProperty(sortType);
    }
}

