/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertSelectionSpecToMDXSet
extends OLAPQueryRule {
    public ConvertSelectionSpecToMDXSet() {
        this.mName = "Convert a SelectionSpec to a MDX set.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{4};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getType() == 4) {
            if (!ConvertSelectionSpecToMDXSet.hasOLAPDataSource(node)) {
                this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
                return false;
            }
            this.traceNodeCondition(true, "SelectionSpec needs to be converted to a MDXSet.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Node is not of type SelectionSpec", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxSetNode = nodeFactory.createNode(2004, node);
        node.exchange(mdxSetNode, true);
    }
}

