/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IQuerySpecAttributeValue;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXLastPeriods;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class ConvertSetFunctionToLastPeriodsMDXFunction
extends OLAPQueryRule {
    public ConvertSetFunctionToLastPeriodsMDXFunction() {
        this.mName = "Convert time periods related functions to the MDX LastPeriods function";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{14};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertSetFunctionToLastPeriodsMDXFunction.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        SetFunction setFunction = (SetFunction)node;
        ESetFunction functionType = setFunction.getFunctionType();
        if (functionType == ESetFunction.LASTPERIODS) {
            this.traceNodeCondition(true, "The relative time functions need to be converted to the MDX LastPeriods", trace);
            return true;
        }
        this.traceNodeCondition(false, "The node is not a relative time.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXLastPeriods lastPeriods = (MDXLastPeriods)nodeFactory.createNode(2032);
        this.replaceCurrentSelection(node, lastPeriods, nodeFactory);
        IXQEQueryNode constant = node.getChild(0);
        IXQEQueryNode attributeValueNode = node.getChild(1);
        if (attributeValueNode instanceof IQuerySpecAttributeValue) {
            throw new IllegalStateException();
        }
        SetFunction setFunction = (SetFunction)node;
        IMember[] context = setFunction.getContext();
        if (context == null || context.length != 1) {
            throw new UnsupportedOperationException();
        }
        String mun = context[0].getUniqueName();
        BaseMember member = (BaseMember)nodeFactory.createNode(2010);
        member.setMemberUniqueName(mun);
        constant.move((IXQEQueryNode)lastPeriods);
        lastPeriods.addChild(member);
    }
}

