/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.ESortDirection;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.query.provider.dim.EPropertyRole;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapLevel;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseProperty;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCurrentMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXOrder;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXProperties;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.SortByAttribute;

public class ConvertSortByAttributeToOrderFunction
extends OLAPQueryRule {
    public ConvertSortByAttributeToOrderFunction() {
        this.mName = "Convert a SortByAttribute selection action to an MDXOrder.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{23};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertSortByAttributeToOrderFunction.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SortByAttribute needs to be converted to an Order function.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionSpecification selectionSpec = (SelectionSpecification)node.getAncestorOfType(4);
        MDXOrder mdxOrder = (MDXOrder)nodeFactory.createNode(2022);
        this.wrapCurrentSelection(node, mdxOrder, nodeFactory);
        SortByAttribute sortNode = (SortByAttribute)node;
        mdxOrder.addChild(this.constructProperties("MEMBER_CAPTION", selectionSpec.getHierarchy().getUniqueName(), nodeFactory));
        int sortType = MDXOrder.determineSortType(ESortDirection.Ascending == sortNode.getSortDirection(), sortNode.isKeepHierarchy());
        mdxOrder.setOrderingProperty(sortType);
    }

    private MDXProperties constructProperties(IAttribute attribute, XQENodeFactory nodeFactory) {
        IDataItem dataItem = attribute.getNode().getDataItem();
        OlapLevel memberProperty = (OlapLevel)dataItem.getPhysicalMetadata();
        return this.constructProperties(memberProperty.getName(), memberProperty.getHierarchy().getUniqueName(), nodeFactory);
    }

    private MDXProperties constructProperties(String propertyName, String hierarchyName, XQENodeFactory nodeFactory) {
        MDXProperties propertiesNode = (MDXProperties)nodeFactory.createNode(2025);
        BaseProperty baseProp = (BaseProperty)nodeFactory.createNode(2026);
        baseProp.setMemberPropertyName(EPropertyRole.MEMBER_CAPTION, propertyName);
        propertiesNode.addChild(baseProp);
        MDXCurrentMember currentMember = (MDXCurrentMember)nodeFactory.createNode(2024);
        propertiesNode.addChild(currentMember);
        BaseHierarchy hierarchy = (BaseHierarchy)nodeFactory.createNode(2012);
        hierarchy.setHierarchyUniqueName(hierarchyName);
        hierarchy.setPropertyValue("membersProjected", Boolean.TRUE);
        currentMember.addChild(hierarchy);
        return propertiesNode;
    }
}

