/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.EHierarchySortOrder;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ISortByHierarchyOrder;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXHierarchize;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertSortByHierarchyOrderToMDXHierarchize
extends OLAPQueryRule {
    public ConvertSortByHierarchyOrderToMDXHierarchize() {
        this.mName = "Convert a SortByAttribute selection action to an MDXOrder.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{26};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertSortByHierarchyOrderToMDXHierarchize.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SortByHierarchyOrder needs to be converted to an Hierarchize function.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ISortByHierarchyOrder sortNode = (ISortByHierarchyOrder)node;
        MDXHierarchize mdxHierarchize = (MDXHierarchize)nodeFactory.createNode(2017);
        if (sortNode.getHierarchySortOrder() == EHierarchySortOrder.ReverseHierarchyOrder) {
            mdxHierarchize.setPropertyValue("post", true);
        }
        this.wrapCurrentSelection(node, mdxHierarchize, nodeFactory);
    }
}

