/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IValuesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IQuerySpecAttributeValue;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertValuesToMDXMembers
extends OLAPQueryRule {
    public ConvertValuesToMDXMembers() {
        this.mName = "Convert a values selection to a MDX Members.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{20};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertValuesToMDXMembers.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Values selection needs to be converted to a BaseMembers.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IValuesSelection valuesSelection = (IValuesSelection)node;
        IQuerySpecAttributeValue[] attributeValues = valuesSelection.getAttributeValues();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (IQuerySpecAttributeValue value : attributeValues) {
            INode metadata = value.getAttribute();
            String mun = value.getIdentifier();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(metadata.isMetric());
            node.getParent().addChild((IXQEQueryNode)baseMember);
        }
        node.detach();
    }
}

