/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IExpandMembers;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXDescendants;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class EvaluateExpandCollapseMembers
extends OLAPQueryRule {
    public EvaluateExpandCollapseMembers() {
        this.mName = "Evaluate expand/collapse members to generate MDX AST nodes";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{28};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!EvaluateExpandCollapseMembers.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "ExpandMember needs to be evaluated.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IExpandMembers expandMembers = (IExpandMembers)node;
        if (expandMembers.isExpandOperation()) {
            this.expandMembers(node, nodeFactory);
        } else {
            this.collapseMembers(node, nodeFactory);
        }
    }

    private void expandMembers(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        IMember[] members;
        IExpandMembers expandMembers = (IExpandMembers)node;
        IXQEQueryNode aSet = nodeFactory.createNode(2004);
        IXQEQueryNode mdxHierarchize = nodeFactory.createNode(2017);
        IXQEQueryNode distinctFunction = nodeFactory.createNode(2049);
        this.wrapCurrentSelection(node, aSet, nodeFactory);
        for (IMember aMember : members = expandMembers.getMembers()) {
            String mun = aMember.getUniqueName();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(aMember.getHierarchy().isValues());
            IXQEQueryNode membersFunction = nodeFactory.createNode(2018);
            membersFunction.addChild((IXQEQueryNode)baseMember);
            aSet.addChild(membersFunction);
        }
        aSet.insertParent(distinctFunction);
        distinctFunction.insertParent(mdxHierarchize);
    }

    private void collapseMembers(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        IMember[] members;
        IExpandMembers expandMembers = (IExpandMembers)node;
        IXQEQueryNode exceptFunction = nodeFactory.createNode(2047);
        this.wrapCurrentSelection(node, exceptFunction, nodeFactory);
        IXQEQueryNode aSet = nodeFactory.createNode(2004);
        for (IMember aMember : members = expandMembers.getMembers()) {
            MDXDescendants descendantsFunction = (MDXDescendants)nodeFactory.createNode(2050);
            descendantsFunction.setRangeFlag(2);
            String mun = aMember.getUniqueName();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(aMember.getHierarchy().isValues());
            descendantsFunction.addChild(baseMember);
            IXQEQueryNode levelFunction = nodeFactory.createNode(2051);
            baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(aMember.getHierarchy().isValues());
            levelFunction.addChild((IXQEQueryNode)baseMember);
            descendantsFunction.addChild(levelFunction);
            aSet.addChild((IXQEQueryNode)descendantsFunction);
        }
        exceptFunction.addChild(aSet);
    }
}

