/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.BoundPhysicalModel;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXComparisonOperator;
import java.util.ArrayList;

public abstract class OLAPQueryRule
extends AbstractRule {
    public static IPhysicalModel getPhysicalModel(IXQEQueryNode node) {
        BoundPhysicalModel boundModelNode;
        if (node.isOfTypes(new int[]{1, 2000})) {
            boundModelNode = (BoundPhysicalModel)node.getFirstChildByType(24);
        } else {
            IXQEQueryNode[] commonAncestors = node.getAncestorsOfTypes(new int[]{1, 2000, 3026});
            if (commonAncestors.length == 0) {
                throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Cannot find ancestors of type QueryNodeTypeEnum.VIEWSPEC or QueryNodeTypeEnum.MDX_QUERY.");
            }
            boundModelNode = (BoundPhysicalModel)commonAncestors[0].getFirstChildByType(24);
        }
        if (null == boundModelNode) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Cannot find node of type QueryNodeTypeEnum.BOUND_PHYSICAL_MODEL.");
        }
        return boundModelNode.getPhysicalModel();
    }

    public static boolean hasOLAPDataSource(IXQEQueryNode node) {
        return EDataSourceType.DIMENSIONAL == OLAPQueryRule.getPhysicalModel(node).getDataSource().getType();
    }

    protected void wrapSetsOrSelections(IXQEQueryNode currentNode, IXQEQueryNode replacementNode, XQENodeFactory nodeFactory) {
        int nodePosition = currentNode.getParent().getPositionOfChild(currentNode);
        IXQEQueryNode spec = this.getSpec(currentNode);
        if (nodePosition == 0) {
            throw new IllegalStateException();
        }
        IXQEQueryNode[] children = spec.getChildren();
        currentNode.exchange(replacementNode);
        IXQEQueryNode aSet = nodeFactory.createNode(2004);
        for (int i = 0; i < nodePosition; ++i) {
            children[i].move(aSet);
        }
        replacementNode.addChild(aSet);
    }

    protected IXQEQueryNode getSpec(IXQEQueryNode node) {
        IXQEQueryNode spec = node.getAncestorOfType(3);
        if (spec == null) {
            return node.getAncestorOfType(2);
        }
        return spec;
    }

    protected void wrapCurrentSelection(IXQEQueryNode currentNode, IXQEQueryNode replacementNode, XQENodeFactory nodeFactory) {
        int nodePosition = currentNode.getParent().getPositionOfChild(currentNode);
        IXQEQueryNode selectionSpec = currentNode.getAncestorOfType(4);
        if (nodePosition == 0) {
            IXQEQueryNode selectAllAction = nodeFactory.createNode(18);
            selectionSpec.addChild(selectAllAction, 0);
            ++nodePosition;
        }
        currentNode.exchange(replacementNode);
        IXQEQueryNode aSet = nodeFactory.createNode(2004);
        IXQEQueryNode[] children = selectionSpec.getChildren();
        for (int i = 0; i < nodePosition; ++i) {
            children[i].move(aSet);
        }
        replacementNode.addChild(aSet);
    }

    protected void replaceCurrentSelection(IXQEQueryNode currentNode, IXQEQueryNode replacementNode, XQENodeFactory nodeFactory) {
        int nodePosition = currentNode.getParent().getPositionOfChild(currentNode);
        IXQEQueryNode selectionSpec = currentNode.getAncestorOfType(4);
        IXQEQueryNode[] children = selectionSpec.getChildren();
        currentNode.exchange(replacementNode);
        for (int i = 0; i < nodePosition; ++i) {
            children[i].detach();
        }
    }

    protected void removeAllChildNodesBefore(IXQEQueryNode aNode, int position) {
        ArrayList<IXQEQueryNode> nodesToRemove = new ArrayList<IXQEQueryNode>();
        for (int j = 0; j < position; ++j) {
            nodesToRemove.add(aNode.getChild(j));
        }
        for (IXQEQueryNode childNode : nodesToRemove) {
            childNode.detach();
        }
    }

    protected IXQEQueryNode generateComparisonExpression(int operator, XQENodeFactory nodeFactory, IXQEQueryNode leftSide, IXQEQueryNode rightSide) {
        MDXComparisonOperator operatorNode = (MDXComparisonOperator)nodeFactory.createNode(2038);
        operatorNode.setOperatorType(operator);
        operatorNode.addChild(leftSide);
        operatorNode.addChild(rightSide);
        return operatorNode;
    }

    protected IXQEQueryNode buildMDXCurrentMemberExpr(XQENodeFactory factory, IHierarchy hierarchy) {
        IXQEQueryNode mdxCurrentMember = factory.createNode(2024);
        BaseHierarchy baseHierarchy = (BaseHierarchy)factory.createNode(2012);
        baseHierarchy.setPropertyValue("suppressMembersProjection", Boolean.TRUE);
        baseHierarchy.setHierarchyUniqueName(hierarchy.getUniqueName());
        mdxCurrentMember.addChild((IXQEQueryNode)baseHierarchy);
        return mdxCurrentMember;
    }
}

