/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.query.queryspec.actions.IAxisAction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import java.util.ArrayList;

public class ReorderAxisActions
extends OLAPQueryRule {
    private static final String ACTIONS_REORDERED = "axisActionsReordered";

    public ReorderAxisActions() {
        this.mName = "Reorder axis actions so they're at the back of the children list";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{2};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ReorderAxisActions.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        Object o = node.getPropertyValue(ACTIONS_REORDERED);
        if (o == null) {
            this.traceNodeCondition(true, "Axis actions need to be reordered.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Axis actions are in the right order.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] children = node.getChildren();
        ArrayList<IXQEQueryNode> actions = new ArrayList<IXQEQueryNode>(children.length);
        for (IXQEQueryNode childNode : children) {
            if (!(childNode instanceof IAxisAction)) continue;
            actions.add(childNode);
        }
        for (IXQEQueryNode aNode : actions) {
            aNode.detach();
        }
        for (IXQEQueryNode aNode : actions) {
            node.addChild(aNode);
        }
        node.setPropertyValue(ACTIONS_REORDERED, (Object)Boolean.TRUE);
    }
}

