/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import java.util.List;

public class ReplaceSetSpecWithMDXNodes
extends OLAPQueryRule {
    public ReplaceSetSpecWithMDXNodes() {
        this.mName = "Replace SetSpecification with a Crossjoin if needed.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{3};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ReplaceSetSpecWithMDXNodes.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SetSpec needs to be converted to a MDX nodes.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List selectionSpecs = node.getDescendantsOfTypeOrdered(4, false);
        if (selectionSpecs.size() > 1) {
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            IXQEQueryNode firstSelection = (IXQEQueryNode)selectionSpecs.get(0);
            IXQEQueryNode selectionsParent = firstSelection.getParent();
            int setInsertPosition = selectionsParent.getPositionOfChild(firstSelection);
            IXQEQueryNode setHolder = nodeFactory.createNode(2016, node);
            selectionsParent.addChild(setHolder, setInsertPosition);
            for (IXQEQueryNode selection : selectionSpecs) {
                selection.move(setHolder);
            }
        }
        node.extract();
    }
}

