/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.IAxisSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import java.util.List;

public class ValidateSuppressTuples
extends OLAPQueryRule {
    private static final String SUPPRESS_TUPLES_VALIDATED = "suppressTuplesValidated";

    public ValidateSuppressTuples() {
        this.mName = "Reorder axis actions so they're at the back of the children list";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{2};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ValidateSuppressTuples.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        IAxisSpecification axisSpec = (IAxisSpecification)node;
        IMember[][] tuples = (IMember[][])axisSpec.getOption(IAxisSpecification.AxisOption.SUPPRESS_TUPLES);
        if (tuples == null) {
            node.setPropertyValue(SUPPRESS_TUPLES_VALIDATED, (Object)true);
            this.traceNodeCondition(false, "Suppress tuples option not set.", trace);
            return false;
        }
        Object o = node.getPropertyValue(SUPPRESS_TUPLES_VALIDATED);
        if (o == null) {
            this.traceNodeCondition(true, "Suppress tuples axis option needs to be validated.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Suppress tuples axis option already validated.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IAxisSpecification axisSpec = (IAxisSpecification)node;
        IMember[][] suppressedTuples = (IMember[][])axisSpec.getOption(IAxisSpecification.AxisOption.SUPPRESS_TUPLES);
        if (suppressedTuples.length < 1) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_AxisOptionNoTuples);
        }
        List selectionsNodes = node.getDescendantsOfTypeOrdered(4, false);
        if (suppressedTuples[0].length != selectionsNodes.size()) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_AxisOptionTupleSizeIncorrect, String.valueOf(suppressedTuples.length));
        }
        IHierarchy[] hierarchies = new IHierarchy[selectionsNodes.size()];
        for (int i = 0; i < hierarchies.length; ++i) {
            hierarchies[i] = ((ISelectionSpecification)selectionsNodes.get(i)).getHierarchy();
        }
        for (IMember[] tuple : suppressedTuples) {
            for (int i = 0; i < tuple.length; ++i) {
                if (hierarchies[i].equals(tuple[i].getHierarchy())) continue;
                throw new QLSRuntimeException(QLSMessageKeys.QSP_AxisOptionHierarchyIncorrect, tuple[i].toString(), (Object)hierarchies[i].toString());
            }
        }
        node.setPropertyValue(SUPPRESS_TUPLES_VALIDATED, (Object)true);
    }
}

