/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ICategoryMetricNode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.DateHierarchyHelper;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.ISQLQueryNode;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAggregate;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLComparison;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLiteral;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRangeVar;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSortKey;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLWindow;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.util.SQLUtil;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;
import java.util.ArrayList;
import java.util.List;

public class BuildInitialSQLQuery
extends SQLQueryRule {
    private static final String INITIAL_SQL_BUILT = "initialSQLBuilt";

    public BuildInitialSQLQuery() {
        this.mName = "Build initial SQL Query.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{3026};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!BuildInitialSQLQuery.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        boolean status = false;
        if (node.getPropertyValue(INITIAL_SQL_BUILT) == null) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(true, "Initial SQL query needs to be constructed.", trace);
        } else {
            this.traceNodeCondition(false, "Initial SQL query has already been constructed.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode prodNode;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect selectNode = (SQLSelect)node;
        IXQEQueryNode sqlGroup = node.getChildrenOfType(3011)[0];
        IXQEQueryNode valueList = sqlGroup.getChild(0);
        sqlGroup.move((IXQEQueryNode)selectNode, 0);
        IXQEQueryNode baseNode = sqlGroup;
        IXQEQueryNode[] filterNodes = node.getChildrenOfType(3009);
        if (filterNodes.length > 0) {
            baseNode = filterNodes[0];
            baseNode.move(sqlGroup, 0);
        }
        if ((prodNode = node.getChildrenOfType(3021)[0]).getNumberChildren() == 1) {
            prodNode.getChild(0).move(baseNode, 0);
            prodNode.extract();
        } else {
            prodNode.move(baseNode, 0);
        }
        SQLRangeVar rangeVar = null;
        ISQLQueryNode outerVList = null;
        List<INode> extraNodes = selectNode.getExtraNodes();
        List<SetFunction> setFunctions = this.getSetFunctions(node);
        if (extraNodes.size() > 0 || setFunctions.size() > 0) {
            rangeVar = (SQLRangeVar)nodeFactory.createNode(3023);
            rangeVar.setName("D1");
            sqlGroup.insertParent((IXQEQueryNode)rangeVar);
            outerVList = (ISQLQueryNode)nodeFactory.createNode(3031);
            for (int i = 0; i < valueList.getNumberChildren() - extraNodes.size(); ++i) {
                outerVList.addChild(SQLUtil.createSQLColumn(nodeFactory, null, String.format("C%d", i)));
            }
            ISQLQueryNode project = (ISQLQueryNode)nodeFactory.createNode(3022);
            rangeVar.insertParent(project);
            project.addChild(outerVList);
        }
        if (setFunctions.size() > 0) {
            this.processSetFunctions(node, setFunctions, nodeFactory, valueList);
        }
        List<String> tables = selectNode.getTables();
        List columns = node.getDescendantsOfTypeOrdered(3004, false);
        for (IXQEQueryNode column : columns) {
            String tableName = ((SQLColumn)column).getTableName();
            int index = tables.indexOf(tableName);
            if (index < 0) continue;
            ((SQLColumn)column).setTableName(String.format("T%d", index));
        }
        selectNode.setPropertyValue(INITIAL_SQL_BUILT, Boolean.TRUE);
    }

    private List<SetFunction> getSetFunctions(IXQEQueryNode node) {
        ArrayList<SetFunction> setFunctions = new ArrayList<SetFunction>();
        List selectionSpecs = node.getDescendantsOfTypeOrdered(4, false);
        for (IXQEQueryNode selectionSpec : selectionSpecs) {
            for (ISelectionAction child : ((SelectionSpecification)selectionSpec).getSelectionActions()) {
                if (!(child instanceof SetFunction)) continue;
                setFunctions.add((SetFunction)child);
            }
        }
        return setFunctions;
    }

    private void processSetFunctions(IXQEQueryNode node, List<SetFunction> setFunctions, XQENodeFactory nodeFactory, IXQEQueryNode valueList) {
        SetFunction function = setFunctions.get(0);
        IXQEQueryNode root = node.getChild(0);
        switch (function.getFunctionType()) {
            case LASTPERIODS: {
                SQLAggregate aggr = (SQLAggregate)nodeFactory.createNode(3000);
                aggr.setSubType(SQLAggregate.SubType.DENSE_RANK);
                SQLWindow window = (SQLWindow)nodeFactory.createNode(3032);
                aggr.addChild(window);
                ISQLQueryNode sortKeyList = (ISQLQueryNode)nodeFactory.createNode(3029);
                SQLLiteral literal = (SQLLiteral)function.getChild(0).extract();
                ICategoryMetricNode category = (ICategoryMetricNode)function.getChild(0).extract();
                INode cNode = category.getNode();
                IConcept concept = cNode.getConcept();
                String conceptName = concept.getName();
                if (conceptName.equals("cQuarter") || conceptName.equals("cMonth") || conceptName.equals("cYear")) {
                    List attributeList = NavigationHelper.getAttributeNodes((INode)cNode);
                    DateHierarchyHelper dateHelper = DateHierarchyHelper.forTemporalCategory((INode)cNode);
                    INode yearAttr = dateHelper.getYearIdentifier();
                    if (yearAttr == null) {
                        yearAttr = cNode;
                    }
                    INode quarterAttr = null;
                    INode monthAttr = null;
                    if (conceptName.equals("cMonth")) {
                        quarterAttr = dateHelper.getQuarterIdentifier();
                        monthAttr = (INode)attributeList.get(0);
                    } else if (conceptName.equals("cQuarter")) {
                        quarterAttr = (INode)attributeList.get(0);
                    }
                    IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)yearAttr);
                    SQLColumn column = SQLUtil.createSQLColumn(nodeFactory, dataItem);
                    SQLSortKey sortKey = (SQLSortKey)nodeFactory.createNode(3028);
                    sortKey.addChild(column);
                    sortKey.setAscending(false);
                    sortKeyList.addChild(sortKey);
                    if (quarterAttr != null) {
                        dataItem = MetadataHelper.getDefaultDataItem((INode)quarterAttr);
                        column = SQLUtil.createSQLColumn(nodeFactory, dataItem);
                        sortKey = (SQLSortKey)nodeFactory.createNode(3028);
                        sortKey.addChild(column);
                        sortKey.setAscending(false);
                        sortKeyList.addChild(sortKey);
                    }
                    if (monthAttr != null) {
                        dataItem = MetadataHelper.getDefaultDataItem((INode)monthAttr);
                        column = SQLUtil.createSQLColumn(nodeFactory, dataItem);
                        sortKey = (SQLSortKey)nodeFactory.createNode(3028);
                        sortKey.addChild(column);
                        sortKey.setAscending(false);
                        sortKeyList.addChild(sortKey);
                    }
                }
                window.addChild(sortKeyList);
                valueList.addChild((IXQEQueryNode)SQLUtil.createAliasNode(nodeFactory, valueList.getNumberChildren(), aggr));
                SQLColumn lChild = SQLUtil.createSQLColumn(nodeFactory, null, String.format("C%d", valueList.getNumberChildren() - 1));
                SQLLiteral rChild = (SQLLiteral)nodeFactory.createNode(3018);
                rChild.setValue(literal.getValue());
                SQLComparison vExpr = (SQLComparison)nodeFactory.createNode(3005);
                vExpr.setSubType(SQLComparison.SubType.LESSEQUAL);
                vExpr.addChild(lChild);
                vExpr.addChild(rChild);
                ISQLQueryNode filter = (ISQLQueryNode)nodeFactory.createNode(3009);
                root.getChild(0).insertParent((IXQEQueryNode)filter);
                filter.addChild(vExpr);
                function.extract();
                break;
            }
        }
    }
}

