/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLogical;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import java.util.ArrayList;

public class BuildSQLFilter
extends SQLQueryRule {
    public BuildSQLFilter() {
        this.mName = "Construct a SQLFilter node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{3026};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!BuildSQLFilter.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        boolean bl = status = node.getChild(0).getType() == 2 && node.getDescendantsOfType(10, false).length > 0;
        if (status) {
            this.traceNodeCondition(true, "SQLFilter node needs to be constructed.", trace);
        } else {
            this.traceNodeCondition(false, "SQLFilter node has already been constructed.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] filters;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode filterNode = null;
        IXQEQueryNode[] children = node.getChildrenOfType(3009);
        if (children.length > 0) {
            filterNode = children[0];
        }
        ArrayList<IXQEQueryNode> predicates = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode filter : filters = node.getDescendantsOfType(10, false)) {
            predicates.add(filter.getChild(0).detach());
            filter.extract();
        }
        IXQEQueryNode predicate = null;
        for (int i = 0; i < predicates.size(); ++i) {
            if (null == predicate) {
                predicate = (IXQEQueryNode)predicates.get(i);
                continue;
            }
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
            logical.setSubType(SQLLogical.SubType.AND);
            logical.addChild(predicate);
            logical.addChild((IXQEQueryNode)predicates.get(i));
            predicate = logical;
        }
        if (filterNode == null) {
            filterNode = nodeFactory.createNode(3009);
            filterNode.addChild(predicate);
            node.addChild(filterNode);
        } else {
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
            logical.setSubType(SQLLogical.SubType.AND);
            filterNode.getChild(0).insertParent((IXQEQueryNode)logical);
            logical.addChild(predicate);
        }
    }
}

