/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;

public class CheckForUnsupportedSelectionActions
extends SQLQueryRule {
    public CheckForUnsupportedSelectionActions() {
        this.mName = "Check for unsupported selection actions.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{18, 19, 20};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!CheckForUnsupportedSelectionActions.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Unsupported selections were found.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String actionName = node.getClass().getName();
        StringBuilder strBldr = new StringBuilder("The selection action \"");
        strBldr.append(actionName);
        strBldr.append("\" is not currently supported by this implementation.");
        throw new UnsupportedOperationException(strBldr.toString());
    }
}

